; Primer 10.
;
; U semi:
;
;   SEND
;  +MORE
;  -----
;  MONEY
;
; zameniti slova dekadnim ciframa tako da se dobije ispravno
; sabiranje. Ista slova se zamenjuju jednakim ciframa, dok
; se razlicita slova zamenjuju razlicitim ciframa. Pri tom
; je S != 0 i M != 0.
;
; Iskodiramo uslove da su svi razliciti, kao i da je svaki u
; skupu {0, 1, ..., 9} (osim M i S koji su u skupu {1,.., 9}.
; Nakon toga mozemo da definisemo uslove koji opisuju sabiranje
; cifara i prenose (za koje uvodimo posebne varijable) ili da
; iskodiramo uslove na neki drugi nacin. Resenje koje daje SMT
; resavac je:
;
;   9567
;  +1085
;-------
;  10652
;
(set-logic QF_LIA)
(declare-fun S () Int)
(declare-fun E () Int)
(declare-fun N () Int)
(declare-fun D () Int)
(declare-fun M () Int)
(declare-fun O () Int)
(declare-fun R () Int)
(declare-fun Y () Int)
(declare-fun P1 () Int)
(declare-fun P2 () Int)
(declare-fun P3 () Int)
(declare-fun P4 () Int)
(assert
 (and
   (distinct S E N D M O R Y)
   (and (<= 1 S) (>= 9 S))
   (and (<= 1 M) (>= 9 M))
   (and (<= 0 E) (>= 9 E)) 
   (and (<= 0 N) (>= 9 N))
   (and (<= 0 D) (>= 9 D))
   (and (<= 0 O) (>= 9 O))
   (and (<= 0 R) (>= 9 R))
   (and (<= 0 Y) (>= 9 Y))

;  Uslovi o sabiranju cifara po pozicijama, uz prenose. 
   (= (+ D E) (+ Y (* 10 P1)))
   (= (+ N R P1) (+ E (* 10 P2)))
   (= (+ E O P2) (+ N (* 10 P3)))
   (= (+ S M P3) (+ O (* 10 P4)))
   (= M P4)

; Alternativno, mozemo zapisati da je prvi sabirak 
; 1000*S + 100*E + 10*N + D; slicno i za drugi sabirak i zbir,
; a zatim prosto izjednacimo zbir dva sabiraka sa zbirom u tom
; dobijenom obliku.
;    (= (+ (* 1000 S) (* 100 E) (* 10 N) D (* 1000 M) (* 100 O) 
;          (* 10 R) E) 
;       (+ (* 10000 M) (* 1000 O) (* 100 N) (* 10 E) Y))
 )
)
(check-sat)
(get-value (S E N D M O R Y))
(exit)
