.intel_syntax noprefix

.text

.global twozeros

# Funkcija:
#
# 	int twozeros(unsigned x);
#
# izracunava broj pojavljivanja dve uzastopne nule u binarnom zapisu 
# broja x. Argument funkcije je:
#
# -- [ebp + 8] -- unsigned x -- dati broj
# 	
twozeros:
	# Prolog funkcije
	enter 0,0
	
	# Ideja algoritma: ako je binarni zapis datog broja dat kao
	# x[31],x[30]...x[1],x[0], gde je x[i] bit na poziciji i u broju, 
	# tada se pomeranjem u desno za jednu poziciju dobija vrednost 
	# 0,x[31],x[30]...x[1]. Ako sada izvrsimo bitovsku disjunkciju 
	# dobijene i originalne vrednosti, dobijamo vrednost:
	# x[31],(x[30]|x[31]),(x[29]|x[30]),...,(x[0]|x[1]). Broj nula
	# u ovom binarnom zapisu (ne racunajuci najvisi bit x[31] koji
        # moze eventualno biti nula) je upravo jednak broju uzastopnih
	# parova nula u originalnom broju. 

	# Ucitavamo argument funkcije u eax
	mov eax, [ebp + 8]
	
	# Pomeramo eax za jednu poziciju u desno (logicki), i to smestamo
	# u ecx.
	mov ecx, eax
	shr ecx, 1

	# Vrsimo logicku disjunkciju eax i ecx.
	or eax, ecx

	# Registar ecx ce biti brojac nula. Inicijalizujemo ga nulom.
	mov ecx, 0 

	# U registar edx smestamo masku cija je vrednost inicijalno
	# 01000...0000
	mov edx, 0x40000000
	
next_bit:
	# Dok maska ne postane nula
	cmp edx, 0
	je last_bit

	# Testiramo bit
	test eax, edx

	# Ako je nula, uvecavamo brojac jedinica.
	je increment
	jmp skip
increment:	
	inc ecx
skip:	
	# Pomeramo masku za jednu poziciju u desno.
	shr edx, 1
	jmp next_bit
last_bit:

	# Smestamo rezultat u eax
	mov eax, ecx


	# Epilog funkcije
	leave
	ret
