.intel_syntax noprefix

.text
.global secret
        
        ## Funkcija secret() pronalazi "tajni" broj za dati cio broj.
	## Argumenti funkcije su:
        ##   [ebp+8] - broj ciji se tajni broj trazi
        ## Pretpostavka je da je dati broj veci ili jednak od 0.
        ## Funkcija vraca izracunati "tajni" broj.  Funkcija se u
	## potpunosti podvrgava C konvencijama pozivanja.
secret:
        ## Prolog funkcije.
        enter   0, 0
        push    ebx
        push    esi
        push    edi

        ## U registar eax se stavlja dati broj.  Registar edi ce drzati
	## vrijednost 10, koja je potrebna prilikom mnozenja i
	## dijeljenja.
        mov     eax, [ebp+8]
        mov     edi, 10

        ## U spoljasnjoj petlji se, polazeci od datog broja, vrsi
	## sabiranje cifara da bi se doslo do vrijednosti za narednu
        ## iteraciju.  U petlji se, radi efikasnijeg racunanja, u svakoj
        ## iteraciji prakticno dobija nova vrijednost sa obrnutim
        ## ciframa; obzirom da su jedino zbirovi cifara ono sto se uzima
        ## u obzir (uz uslov da relacija susjednosti medju ciframa bude
	## odrzana), ovo ne utice na finalni rezultat.
        
next_iteration:
        ## Provjerava se da li se doslo do "tajnog" broja polaznog broja.
        cmp     eax, 10
        jl done

        ## Vrsi se sabiranje parova cifara da bi se doslo do vrijednosti
        ## za narednu iteraciju, koja se akumulira u registru ecx.
        ## Registar ebx ce sadrzati prethodnu cifru, registar esi tekucu
 	## cifru. Treba uociti da broj cifara na ovom mjestu mora biti
	## veci ili jednak 2. Ocitava se cifra najmanje tezine.
        cdq
        idiv    edi
        mov     ebx, edx
        xor     ecx, ecx
        
next_pair:
        ## Ocitava se tekuca cifra i dodaje prethodnoj cifri.  Ako je
	## rezultat veci od 10, cifre rezultata bi opet trebalo sabrati;
	## obzirom da rezultat ne moze biti veci ili jednak 20, ovo se
	## prosto postize oduzimanjem broja 9 od rezultata.
        cdq
        idiv    edi
        mov     esi, edx
        add     ebx, esi
        cmp     ebx, 10
        jl accumulation
        sub     ebx, 9
       
accumulation:
        ## Ukljucuje se novodobijena cifra u novu vrijednost kao cifra
	## najmanje tezine.
        xchg    ecx, eax
        imul    edi
        add     eax, ebx
        xchg    eax, ecx

        ## Tekuca cifra postaje prethodna cifra i nastavlja se sa
	## sabiranjem parova cifara tekuce vrijednosti.
        mov     ebx, esi
        cmp     eax, 0
        jg next_pair

        ## Prelazi se na narednu iteraciju spoljasnje petlje.
        mov     eax, ecx
        jmp next_iteration

done:        
        ## Epilog funkcije.
        pop     edi
        pop     esi
        pop     ebx
        leave
        ret
