.intel_syntax noprefix
        
.text
.global euler

       	## Funkcija euler() odredjuje koliko ima brojeva manjih od datog
        ## broja koji su uzajamno prosti sa njime.  Argumenti funkcije
	## su:
        ##   [ebp+8] - dati broj
        ## Pretpostavka je da je dati broj veci od 0.  Funkcija se u
	## potpunosti podvrgava C konvencijama pozivanja.
euler:
        ## Prolog funkcije.
        enter   0, 0
        push    ebx
        push    esi
        push    edi

        ## Registar esi ce sadrzati dati broj.  Registar ecx ce sluziti
	## kao brojac kroz sve brojeve manje od datog broja.  Registar
	## edi ce brojati koliko ima trazenih brojeva.
        mov     esi, [ebp+8]
        mov     ecx, esi
        dec     ecx
        xor     edi, edi

        ## Provjerava se da li ima potrebe uopste ulaziti u glavnu
	## petlju programa (za slucaj kada je dati broj jednak 1).
        jecxz done
        
next_number:
        ## Za Euklidov algoritam, koji ce biti iskoriscen za
        ## odredjivanje najveceg zajednickog djelioca (NZD) datog broja,
        ## i tekuceg broja koji je manji od datog broja, u registru eax
	## ce biti cuvan veci, a u registru ebx manji od dva broja za
	## tekuci korak algoritma
        mov     eax, esi
        mov     ebx, ecx

next_iteration:
        ## Dijeli se veci broj za tekuci korak Euklidovog algoritma sa
	## manjim.
        xor     edx, edx
        div     ebx

        ## Provjerava se da li je ostatak dijeljenja jednak 0, u kom
	## slucaju je pronadjen najveci NZD polaznog para brojeva.
        cmp     edx, 0
        je check_coprimality

        ## U suprotnom, manji od dva broja u tekucem koraku Euklidovog
        ## algoritma postaje veci broj za narednu iteraciju, a ostatak
	## dijeljenja postaje manji broj.
        mov     eax, ebx
        mov     ebx, edx
        jmp next_iteration

check_coprimality:
        ## Po zavrsetku Euklidovog algoritma, NZD datog para brojeva je
        ## manji od dva broja u zadnjem koraku algoritma, odn. to je
        ## sadrzaj registra ebx; provjerava se da li je taj NZD jednak
        ## 1, u kom slucaju su dva polazna broja uzajamno prosti, pa se
	## inkrementira registar koji broji koliko ima trazenih brojeva.
        cmp     ebx, 1
        ja continue
        inc     edi

continue:
        ## Prelazi se na naredni broj koji je manji od datog broja.
        loop    next_number

done:
        ## Rezultat izracunavanje se prebacuje u registar eax, kako bi
	## bio vracen kao rezultat funkcije.
        mov     eax, edi

        ## Epilog funkcije.
        pop     edi
        pop     esi
        pop     ebx
        leave
        ret
