.intel_syntax noprefix


.text

.global sub_string
###########################################
## int sub_string(char *str, char *sub);
## 
## Funkcija ispituje da li je string sub
## podstring stringa str. Pod podstringom
## se potrazumeva svaki podniz karaktera
## (ne obavezno uzastopan). Vraca 0 ili 1.
##
## char *str -- [ebp+8]
## char *sub -- [ebp+12]
##
###########################################
sub_string:

## Prolog funkcije
enter 0,0
push edi
push esi

## Ideja: kretacemo se kroz prvi string, i 
## trazicemo u njemu tekuci karakter drugog
## stringa. Kada ga pronadjemo, prelazimo
## na sledeci karakter drugog stringa, dok
## pretragu u prvom stringu nastavljamo
## od pozicije gde smo stali. Na kraju, ako
## nismo pronasli sve karaktere drugog stringa
## vracamo 0. U suprotnom vracamo 1.


## Iskljucujemo DF. Time obezbedjujemo da se 
## stringovi obilaze s leva na desno. 
cld

## Racunamo duzinu prvog stringa, i smestamo
## je u ecx. To ce nam biti broj iteracija u
## narednoj petlji u kojoj pretrazujemo 
## prvi string.
mov edi,[ebp+8]
xor al,al
mov ecx,-1
repne scasb
neg ecx
sub ecx,2

## Smestamo adresu prvog stringa u edi, a
## adresu drugog stringa u esi.
mov esi,[ebp+12]
mov edi,[ebp+8]

## U ovoj petlji prolazimo kroz sve
## karaktere drugog stringa: za svaki
## karakter drugog stringa pretrazujemo
## prvi string. Ukoliko ga ne pronadjemo
## izlazimo iz petlje (failure). Ako 
## ucitamo karakter '\0' iz drugog stringa,
## znaci da su svi karakteri drugog stringa
## pronadjeni, i u tom slucaju izlazimo iz
## petlje (success).
next_char:
lodsb
cmp al,0
je success
repne scasb
jne failure
jmp next_char


## Slucaj neuspeha
failure:
xor eax,eax
jmp done

## Slucaj uspeha
success:
mov eax,1

## Epilog funkcije
done:
pop esi
pop edi
leave
ret
