.intel_syntax noprefix

.text
.global scalar
########################################
## int scalar(int x[], int y[], int n);
##
## Funkcija vraca skalarni proizvod
## vektora x i y dimenzije n.
##
## int *x -- [ebp+8]
## int *y -- [ebp+12]
## int  n -- [ebp+16]
##
########################################
scalar:

## Prolog funkcije
enter 0,0
push edi
push esi
push ebx

## U registar esi ucitavamo adresu prvog niza
## U registar edi ucitavamo adresu drugog niza
## U registar ecx ucitavamo dimenziju nizova
mov esi, [ebp+8]
mov edi, [ebp+12]
mov ecx, [ebp+16]

## Registar ebx ce nam sluziti za izracunvanje
## sume. 
xor ebx,ebx

## Postavljamo smer kretanja kroz nizove s leva
## u desno.
cld

## Petlja u kojoj ucitavamo po jedan element iz
## oba niza, mnozimo ih i dodajemo na sumu.
next_element:

## Ucitavamo element niza x
lodsd

## Odlazemo na stek dosadasnju sumu jer nemamo
## dovoljno registara, a treba nam jedan za
## jedan od faktora.
push ebx

## Prebacujemo ucitani element niza x u ebx
mov ebx,eax

## Razmenjujemo sadrzaje registara esi i edi.
## Ovim postizemo da nam se u esi registu sada
## nalazi adresa tekuceg elementa niza y.
xchg esi,edi

## Ucitavamo element niza y.
lodsd

## Mnozimo tekuce elemente. Proizvod nam se
## nalazi u edx:eax.
imul ebx

## Vracamo dosadasnju sumu u ebx, i uvecavamo je
## za vrednost 
pop ebx
add ebx,eax

## Oper razmenjujemo vrednosti registara esi i edi
## i pripremamo se za ucitavanje sledeceg elementa
## niza x.
xchg esi,edi
loop next_element

## Prebacujemo sumu u registar eax.
mov eax,ebx

## Epilog funkcije
pop ebx
pop esi
pop edi
leave
ret
