#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

/* Maksimalna duzina stringa */
#define MAX_STR 256

/* Deklaracija asemblerske funkcije */
void longest(char *str, int *start, int *length);

/* test program */
int main(int argc, char **argv)
{

char str[MAX_STR];
char * pos = NULL;
int start, length;

/* ucitavamo string */
errno=0;
clearerr(stdin);
if(fgets(str, MAX_STR, stdin) == NULL)
 if(ferror(stdin))
  {
    fprintf(stderr, "%s: fgets() error: %s\n", argv[0], strerror(errno));
    exit(EXIT_FAILURE);
  }

/* eliminisemo potencijalni znak za novi red */
if((pos = strchr(str, '\n')) != NULL)
  *pos = '\0';

/* Poziv funkcije longest() i ispis poruke */
longest(str, &start, &length);

printf("%d %d\n", start, length);

return EXIT_SUCCESS;

}
