.intel_syntax noprefix


.text
.global longest
####################################################
## void longest(char *str, int *start, int *length);
##
## Funkcija odredjuje poziciju i duzinu najduze
## sekvence istih karaktera u stringu str. Ako
## ima vise takvih sekvenci, vratiti prvu.
##
## [ebp+8] -- char *str
## [ebp+12] -- int *start
## [ebp+16] -- int *length
##
####################################################
longest:

## Prolog funkcije
enter 0,0
push edi
push esi
push ebx


## U registar esi smestamo adresu stringa.
mov esi,[ebp+8]


## Registar ebx nam cuva pocetak do sada najduze
## sekvence istih karaktera. Registar edx ce nam
## cuvati duzinu te sekvence.
xor ebx,ebx 
xor edx,edx


## Registar edi cemo koristiti za cuvanje pocetka
## tekuce sekvence istih karaktera. Registar ecx
## ce nam biti duzina tekuce sekvence.
xor edi,edi
xor ecx,ecx 

## Postavljamo smer obilaska stringa sa leva u desno.
cld

## Ucitavamo prvi karakter. Ako je 0, tada je u pitanju
## prazan string, pa vracamo dve nule, kao poziciju i
## duzinu najduze sekvence.
lodsb
cmp al,0
je done

## Ako nije nula, tada je on predstavlja pocetak sekvence.
## Prebacujemo ga u ah, koji ce nam cuvati prethodni kara-
## kter, za potrebe poredjenja sa sledecim karakterom koji
## se uvek ucitava u al. Takodje, inicijalizujemo tekucu 
## sekvencu, postavljanjem ecx na 1.
mov ah,al
inc ecx

## Petlja next_char ucitava karakter po karakter u
## registar al, i poredi ga sa prethodnim karakterom
## u registru ah. 
next_char:
lodsb
cmp al,ah
jne not_equal

## Ako su jednaki, tada se samo uvecava duzina tekuce 
## sekvence (ecx). Prebacuje se ah u al i nastavlja se
## sa sledecim karakterom.
equal:
inc ecx
mov ah, al
jmp next_char

## Ako nisu jednaki, tada je tekuca sekvenca zavrsena
## pa treba da proverimo da li je duza od do sada 
## najduze sekvence.
not_equal:
cmp ecx,edx
jle not_greater

## Ako je duza, tada azuriramo ebx i edx.
greater:
mov ebx,edi
mov edx,ecx

## U svakom slucaju, inicijalizujemo novu 
## tekucu sekvencu.
not_greater:
add edi,ecx
mov ecx,1

## Proveravamo da li je poslednji ucitani 
## karakter 0. Ako jeste, izlazimo iz
## funkcije. Ako nije, prebacujemo ga u
## ah i nastavljamo sa sledecim karakterom.
cmp al,0
je done
mov ah,al
jmp next_char


done:

## Upisujemo rezultate u za to predvidjene lokacije
mov edi,[ebp+12]
mov [edi], ebx
mov edi, [ebp+16]
mov [edi], edx

## Epilog funkcije
pop ebx
pop esi
pop edi
leave
ret
