.intel_syntax noprefix
	
.data
wrfmt:	.asciz  "%c\n"		# Izlazni format.
	
.bss
.lcomm	s0, 80			# Prvi string.
.lcomm	s1, 80			# Drugi string.
			
.text
.global main

main:
        ## Prolog funkcije.
	enter	0, 0
	pusha

	## Ucitava se prvi string. Radi jednostavnosti je za ucitavanje
	## stringa koriscena gets() funkcija; pretpostavka je da uneseni
	## stringovi nece biti duzi od 79 karaktera. Ovu funkciju zbog
        ## mogucnosti buffer overflow-a inace NIKAD ne treba 
	## upotrebljavati, vec umjesto nje treba koristiti fgets() 
	## funkciju.
	lea	eax, s0
	push	eax
	call gets
	add	esp, 4

	## Ucitava se drugi string.
	lea	eax, s1
	push	eax
	call gets
	add	esp, 4

	## Brise se direction fleg, obzirom da ce sve instrukcije za rad
	## sa stringovima prolaziti kroz stringove prema naprijed.
	cld

	## Odredjuje se duzina prvog stringa. String je terminiran 
	## nulom, tako da se u al registar stavlja 0, a u edi registar
	## adresa prvog karaktera u stringu i onda se scas instrukcijom
	## ispituju redom karakteri stringa dok se ne naidje na karakter
	## koji je jednak 0. Duzina stringa se akumulira u registru ecx.
	xor	al, al
	lea	edi, s0
	xor	ecx, ecx
next_char0:
	scasb
	je compare
	inc	ecx
	jmp next_char0

compare:
	## Izracunata duzina se inkrementira za 1 da bi pri
	## poredjenju bio uzet u obzir i terminirajuci karakter.
	## Potom se porede stringovi. U registrima esi i edi se drze
	## adrese tekucih karaktera stringova. U petlji se u svakom
	## koraku cmps instrukcijom porede ova dva karaktera.
	inc	ecx
	lea	esi, s0
	lea	edi, s1
next_char1:
	cmpsb
	loope next_char1

	## Ako je petlja zavrsena jer su pronadjena dva razlicita
	## karaktera, u registar al se smjesta karakter 'n', a u
	## suprotnom se u isti registar smjesta karakter 'y'.
	jne not_equal
	xor	eax, eax
	mov	al, 'y'
	jmp print
not_equal:
	xor	eax, eax
	mov	al, 'n'

print:
	## Stampa se rezultat poredjenja.
	push	eax
	lea	eax, wrfmt
	push	eax
	call printf
	add	esp, 8
		
	## Epilog funkcije.
	popa
	xor	eax, eax
	leave
        ret
