.intel_syntax noprefix

.data
one: .double 1.0
mask: .int 0xffffffff, 0x7fffffff, 0x0, 0x0
	
.text 
.global nth_root
#############################################################################
##
## Funkcija:
##
## double nth_root(double x, int n, double eps);
##
## racuna n-ti koren broja x vavilonskim metodom sa preciznoscu eps.
## U pitanju je iterativni metod x_{k+1} = 1/n*((n-1)x_k + x/x_k^(n-1)),
## pri cemu se za x_0 uzima proizvoljan broj (u nasem slucaju x_0 = 1).
## Iteracija se prekida kada je |x_{k+1} - x_k| < eps. Argumenti funkcije
## su:
## 
## -- double x 	 --  [ebp+8]  -- broj ciji se koren racuna
## -- int n      --  [ebp+16] -- koren koji racunamo
## -- double eps --  [ebp+20] -- trazena preciznost
##
############################################################################ 
nth_root:
	## Prolog funkcije
	enter 0,0

	## Ucitavamo pocetno stanje steka
	fld1 				## stek: 1 = x0 = x_k (k = 0)
	fld qword ptr [ebp + 8]		## stek: xk, x
	fild dword ptr [ebp + 16] 	## stek: xk, x, n
	fld st(0)			## stek: xk, x, n, n
	fsub st(0), st(3)		## stek: xk, x, n, n-1

	## Petlja racuna sledeci x(k+1) = 1/n[(n-1)xk + x/xk^(n-1)]
next:
	fld st(3)			## stek: xk,x,n,n-1,xk
	fmul st(0), st(1)		## stek: xk,x,n,n-1,(n-1)xk
	fld st(1)			## stek: xk,x,n,n-1,(n-1)xk,(n-1)
	fld st(5)			## stek: xk,x,n,n-1,(n-1)xk,(n-1),xk
	fyl2x				## stek: xk,x,n,n-1,(n-1)xk,(n-1)log2(xk)=L
	fld st(0)			## stek: xk,x,n,n-1,(n-1)xk,L,L
	frndint				## stek: xk,x,n,n-1,(n-1)xk,L,int(L)
	fxch				## stek: xk,x,n,n-1,(n-1)xk,int(L),L
	fsub st(0), st(1)		## stek: xk,x,n,n-1,(n-1)xk,int(L),frac(L)
	f2xm1				## stek: xk,x,n,n-1,(n-1)xk,int(L),2^frac(L)-1
	fld1				## stek: xk,x,n,n-1,(n-1)xk,int(L),2^frac(L)-1,1
	faddp				## stek: xk,x,n,n-1,(n-1)xk,int(L),2^frac(L)
	fscale				## stek: xk,x,n,n-1,(n-1)xk,int(L),2^L
	fxch				## stek: xk,x,n,n-1,(n-1)xk,2^L,int(L)
	ffree st(0)
	fincstp				## stek: xk,x,n,n-1,(n-1)xk,2^L=xk^(n-1)
	fdivr st(0),st(4)		## stek: xk,x,n,n-1,(n-1)xk,x/xk^(n-1)
	faddp				## stek: xk,x,n,n-1,(n-1)xk + x/xk^(n-1)
	fdiv st(0), st(2)		## stek: xk,x,n,n-1,((n-1)xk + x/xk^(n-1))/n=x(k+1)

	## Uporedjujemo |xk-x(k+1)| < eps
	fxch st(4)			## stek: x(k+1),x,n,n-1,xk
	fsub st(0), st(4)		## stek: x(k+1),x,n,n-1,xk - x(k+1)
	fabs				## stek: x(k+1),x,n,n-1,|xk - x(k+1)|
	fld qword ptr [ebp + 20]	## stek: x(k+1),x,n,n-1,|xk - x(k+1)|,eps
	fcomip st(0), st(1)		## stek: x(k+1),x,n,n-1,|xk - x(k+1)|

	## Ako je eps vece, izlazimo iz petlje
	ja last

	## Prelazimo na sledecu iteraciju
	ffree st(0)
	fincstp				## stek: x(k+1),x,n,n-1
	jmp next
last:	

	## Skidamo sa steka nepotrebne vrednosti. Na vrhu steka ostaje samo rezultat.
	ffree st(0)
	fincstp				## stek: x(k+1),x,n,n-1
	ffree st(0)
	fincstp
	ffree st(0)
	fincstp
	ffree st(0)
	fincstp				## stek: x(k+1)

	
	## Epilog funkcije.
	leave
	ret
