.text
.align 2


.global happy

@ Funkcija:
@
@ int happy(unsigned x);
@
@ ispituje da li je broj x srecan. Argumenti funkcije su:
@
@ -- r0 -- unsigned x -- dati broj
@
happy:
	@ Prolog funkcije
	stmfd sp!, {fp, lr}
	mov fp, sp

	@ Smestamo na stek registre koje cemo koristiti.
	stmfd sp!, {r4-r5}

	@ U r4 cemo cuvati tekuci broj. Inicijalno je jednak broju x.
	mov r4, r0

next_number:
	@ Ako je jednak 1, tada je polazni broj srecan.
	cmp r4, #1
	beq is_happy
	
	@ Ako je jednak 4, tada polazni broj nije srecan.
	cmp r4, #4
	beq not_happy

	@ Registar r5 ce sadrzati sumu kvadrata cifara.
	mov r5, #0
next_digit:
	@ Dok ima cifara...
	cmp r4, #0
	beq last_digit

	@ Odredjujemo cifru jedinica
	mov r0, r4
	mov r1, #10
	bl __modsi3 

	@ Kvadriramo cifru i dodajemo je na sumu.
	mov r3, r0
	mul r2, r3, r0
	add r5, r5, r2
	
	@ Delimo broj sa 10, za sledecu iteraciju.
	mov r0, r4
	mov r1, #10
	bl __divsi3
	mov r4, r0
	b next_digit
last_digit:

	@ Zbir kvadrata cifara je novi broj.
	mov r4, r5
	b next_number

is_happy:
	@ Ako je srecan, vracamo 1.
	mov r0, #1
	b skip

not_happy:
	@ U suprotnom vracamo 0.
	mov r0, #0
	
skip:
	@ Vracamo vrednosti registara koje smo koristili.
	ldmfd sp!, {r4-r5}

done:
	@ Epilog funkcije
	mov sp, fp
	ldmfd sp!, {fp, pc}
