.intel_syntax noprefix

.data
ten:	.int 10

.text
.global ascending

##########################################################################
##
## Funkcija:
##
## int ascending(unsigned n);
##
## ispituje da li se dekadni zapis datog broja sastoji iz strogo rastuceg
## niza cifara. Argumenti funkcije su:
##
## -- unsigned n  -- [ebp+8]  -- dati broj
##
###########################################################################
ascending:
        ## Prolog funkcije.
        enter   0, 0

	## Ucitavamo broj n u eax.
	mov eax, [ebp + 8]

	## Izdvajamo cifru jedinice i smestamo je u ecx
	xor edx, edx
	div dword ptr ten
	mov ecx, edx

next:
	## Dokle god ima jos cifara u broju
	cmp eax, 0
	je one

	## Uzimamo sledecu cifru (sa desna u levo)
	xor edx, edx
	div dword ptr ten

	## Sledeca cifra mora biti strogo manja. Ako nije, izlazimo
	## iz petlje i vracamo 0.
	cmp edx, ecx
	jae zero

	## Pamtimo poslednju procitanu cifru u ecx i prelazimo na
	## sledecu iteraciju.
	mov ecx, edx
	jmp next

one:
	mov eax, 1
	jmp done

zero:
	mov eax, 0
	
done:	
	## Epilog funkcije
	leave
	ret
	