.intel_syntax noprefix

.text

.global izbaci

## Funkcija unsigned izbaci(unsigned x) izbacuje
## sva pojavljivanja najvece cifre u dekadnom zapisu
## broja x. Argument funkcije je:
## 
## unsigned x -- ebp + 8
##
izbaci:
	enter 0,0
	push esi
	push ebx
	push edi
	
	mov eax, [ebp + 8]   ## broj x
	xor ecx, ecx         ## brojac cifara i = 0
	mov ebx, 10
	xor esi, esi         ## najveca pronadjena cifra

	## Petlja izdvaja cifru po cifru (pocev od cifre najmanje
	## tezine), postavlja ih na stek, broji koliko ih ima i
	## odredjuje najvecu cifru. 
sledece_deljenje:
	xor edx, edx
	div ebx

	## Postavljamo cifru na stek i uvecavamo brojac
	push edx
	inc ecx

	## Azuriramo po potrebi najvecu cifru
	cmp edx, esi
	ja novi_max
	jmp preskoci
novi_max:
	mov esi, edx
preskoci:

	## Kada nema vise cifara, izlazimo iz petlje
	cmp eax, 0
	je poslednje_deljenje
	jmp sledece_deljenje
poslednje_deljenje:	

	## Druga petlja skida cifru po cifru sa steka. Cifre jednake
	## najvecoj cifri ignorise. Ostale cifre ubacuje u broj
	## Hornerovom semom. 
	xor eax, eax   # Rezultat S = 0
petlja2:
	## Ako nema vise cifara, kraj petlje
	cmp ecx, 0
	je petlja2_kraj

	## Skidamo cifru sa steka
	pop edi

	## Preskacemo cifre jednake najvecoj cifri
	cmp edi, esi
	je preskoci_najvecu

	## Mnozimo sa 10 i dodajemo cifru
	mul ebx
	add eax, edi	
	
preskoci_najvecu:
	## Smanjujemo brojac cifara i skacemo na pocetak petlje
	dec ecx
	jmp petlja2
petlja2_kraj:	

	## Na kraju u eax registru ostaje vrednost koju treba vratiti
	
	pop edi
	pop ebx
	pop esi
	leave
	ret
