.intel_syntax noprefix

.data
two:    .int    2    # Broj 2
	
.text
.global trapezoid
#############################################################################
##
## Funkcija:
##
## double trapezoid(double a, double b, int n);
##
## racuna integral funkcije sin(x) trapeznom formulom. Argumenti funkcije su:
## 
## -- double a --  [ebp+8] -- leva granica intervala.
## -- double b --  [ebp+16] - desna granica intervala
## -- int n    --  [ebp+24] - broj podintervala
##
## Pretpostavlja se da je broj podintervala veci ili jednak 2. Funkcija vraca
## vrednost integrala.
##
############################################################################ 
trapezoid	:
        ## Prolog funkcije.
        enter	0, 0

	## Registar ecx ce se koristiti kao brojac za unutrasnje cvorove
	## (kojih ima n-1).
	mov	ecx, [ebp+24]
	dec	ecx

	## Izracunava se korak h.
	fld	qword ptr [ebp+16]	# Stek: b
	fld	qword ptr [ebp+8]	# Stek:	b, a
	fsubp				# Stek:	b-a
	fild	dword ptr [ebp+24]	# Stek:	b-a, n
	fdivp				# Stek:	(b-a)/n=h

	## Prvo ce biti izracunata suma vrednosti funkcije u
	## unutrasnjim cvorovima intervala. Unutrasnji cvorovi ce biti
	## oznacavani u komentarima sa x[k] (pri cemu k ide od 1 do
	## n-1). Parcijalna suma u koju su uracunate vrednosti
	## funkcije u cvorovima sa indeksima od 1 do k bice oznacena sa
	## S[k]. Parcijalna suma se inicijalizuje na 0 i stavlja na vrh
	## steka, a onda se na vrh steka stavlja i donja granica
	## intervala.
	fldz				# Stek:	h, 0=S[0]
	fld	qword ptr [ebp+8]	# Stek:	h, S[0], a=x[0]

next_node:
	## Izracunava se naredni cvor (tako sto se na tekuci doda duzina
	## koraka h). Zatim se ovaj cvor udvaja na vrhu steka,
	## izracunava se vrednost funkcije u cvoru i dodaje se ta
	## vrednost parcijalnoj sumi.
	fadd	st, st(2)	# Stek:	h, S[k-1], x[k-1]+h=x[k]
	fld	st		# Stek:	h, S[k-1], x[k], x[k]
	fsin			# Stek:	h, S[k-1], x[k], sin(x[k])
	faddp	st(2), st	# Stek:	h, S[k-1]+sin(x[k])=S[k], x[k]
	loop next_node

	## Odbacuje se vrednost koja se nalazi na vrhu steka.
	ffree	st		# Stek: h, S[n-1], invalidna vrednost
	fincstp			# Stek: h, S[n-1]

	## Mnozi se parcijalna suma sa 2.
	fimul	dword ptr two	# Stek:	h, 2*S[n-1]

	## Dodaju se na parcijalnu sumu vrednosti funkcije u granicama
	## intervala, cime se suma kompletira.
	fld	qword ptr [ebp+8]	# Stek:	h, 2*S[n-1], a
	fsin				# Stek: h, 2*S[n-1], sin(a)
	faddp				# Stek: h, sin(a)+2*S[n-1],
	fld	qword ptr [ebp+16]	# Stek: h, sin(a)+2*S[n-1], b
	fsin				# Stek: h, sin(a)+2*S[n-1], sin(b)
	faddp				# Stek: h, sin(a)+2*S[n-1]+sin(b)

	## Mnozi se suma sa h/2, cime se kompletira izracunavanje.
	fmulp			# Stek: h*(sin(a)+2*S[n-1]+sin(b))
	fidiv	dword ptr two	# Stek: h/2*(sin(a)+2*S[n-1]+sin(b))
	
        ## Epilog funkcije.
        leave
        ret
