.intel_syntax noprefix

.text
.global sequence

##########################################################################
##
## Funkcija:
##
## void sequence(char * string, int * index, int * length);
##
## odredjuje indeks prvog karaktera u prvoj najduzoj sekvenci samoglasnika
## u datom stringu, kao i duzinu te sekvence.  Argumenti funkcije su:
##
## -- char * string -- [ebp+8]  -- adresa prvog karaktera stringa
## -- int * index --   [ebp+12] -- adresa na koju treba upisati indeks prvog
##                                 karaktera sekvence
## -- int * length  -- [ebp+16] -- adresa na koju treba upisati duzinu
##				   sekvence
##
###########################################################################
sequence:
        ## Prolog funkcije.
        enter   0, 0
        push    ebx
        push    esi
        push    edi

        ## Postavlja se direction fleg i inicijalizuje se registar esi
        ## koji ce cuvati adresu tekuceg karaktera tokom procesiranja
	## stringa.
        cld
        mov     esi, [ebp+8]

        ## Registar ebx ce cuvati adresu karaktera kojim pocinje dosad
        ## najduza sekvenca u stringu, a registar ecx duzinu sekvence.
	## Inicijalizuju se vrednosti ovih registara.
        mov     ebx, esi
        xor     ecx, ecx

	## Inicijalizujemo registar ah. Registar ah ce sadrzati 1 ako je
	## prethodni karakter bio samoglasnik, a 2 ako prethodni karakter
	## nije bio samoglasnik. Inicijalna vrednost je 2, za slucaj da je
	## prvi karakter samoglasnik (kako bi odmah zapoceo novu sekvencu).
	mov ah, 2
	
        ## U petlji se procesiraju karakteri datog stringa.
next_character:
	
        ## Ucitava se naredni karakter.
        lodsb

	## Ispituje se da li je nastupio kraj stringa.
	cmp     al, 0
	je end_of_string
	
	## Ispituje se da li je tekuci karakter samoglasnik.
        cmp     al, 'a'
        je vowel
	cmp     al, 'A'
        je vowel
	cmp     al, 'e'
        je vowel
	cmp     al, 'E'
        je vowel
	cmp     al, 'i'
        je vowel
	cmp     al, 'I'
        je vowel
	cmp     al, 'o'
        je vowel
	cmp     al, 'O'
        je vowel
	cmp     al, 'u'
        je vowel
	cmp     al, 'U'
        je vowel
	jmp not_vowel

	## Ako je tekuci karaker samoglasnik...
vowel:
	## Upisujemo 1 u al (to ce kasnije doci u ah, kada se registri razmene
	## na kraju iteracije).
	mov al, 1

	## Ako je prethodni karakter bio samoglasnik, samo treba uvecati
	## brojac (jos uvek smo u istoj sekvenci). U suprotnom, ako je
	## prethodni karakter bio suglasnik, tada je ovo pocetak nove
	## sekvence.
	cmp ah, 1
	jne initialize_sequence
	inc edx
	jmp continue

	## Ako tekuci karakter nije samoglasnik...
not_vowel:
	## Upisujemo 2 u al (to ce kasnije doci u ah, kada se registri razmene
	## na kraju iteracije).
	mov al, 2

	## Ako je prethodni karakter bio samoglasnik, tada je ovo kraj
	## tekuce sekvence. U suprotnom, nismo u sekvenci samoglasnika
	## i prosto prelazimo na sledeci karakter.
	cmp ah, 1
	je end_of_sequence
	jmp continue
	
	## Ako je nastupio kraj stringa...
end_of_string:
	## U registru al ostaje 0. Ako je prethodni karakter (poslednji u
	## stringu) bio samoglasnik, tada je kraj stringa ujedno i kraj te
	## sekvence. 
	cmp ah, 1
	je end_of_sequence
	jmp continue
	
end_of_sequence:	
        ## Poredi se duzina tekuce sekvence sa duzinom dosad najduze sekvence
	## i po potrebi se azuriraju duzina najduze sekvence i adresa njenog
	## prvog karaktera.
        cmp     ecx, edx
        jge continue
        mov     ebx, edi
        mov     ecx, edx
	jmp continue
	
initialize_sequence:
        ## Inicijalizuje se adresa prvog karaktera nove sekvence i njena
	## duzina.
        mov     edi, esi
	dec     edi
        mov     edx, 1
	jmp continue

continue:
	## Razmenjuju se vrednosti registara al i ah. Time u ah odlazi
	## 0, 1 ili 2 u zavisnosti od toga da li je tekuci karakter
	## terminirajuca nula, samoglasnik ili ne-samoglasnik, respektivno.
	xchg    al, ah
	
	## Proverava se da li se doslo do kraja stringa i ako to nije
	## slucaj nastavlja se sa iteracijama. 
        cmp     ah, 0
        jne next_character

	## S obzirom da se trazi indeks pocetka najduze sekvence samoglasnika
	## potrebno je izracunati ga. U registru ebx imamo adresu pocetnog
	## karaktera te sekvence. Oduzimanjem adrese pocetka stringa od ove
	## adrese dobijamo trazeni indeks.
	mov eax, [ebp+8]
	sub ebx, eax
	
        ## Upisuju se izracunate vrednosti u za to predvidjene memorijske
	## lokacije.
        mov     eax, [ebp+12]
        mov     [eax], ebx
        mov     eax, [ebp+16]
        mov     [eax], ecx

        ## Epilog funkcije.
        pop     edi
        pop     esi
        pop     ebx
        leave
        ret
