#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <stdlib.h>

#define MEM_SIZE  256
#define AC_SIZE  256 /* Raspon vrednosti akumulatora */
#define MAX_WORD 80
#define MAX_SIM 56
#define SIM_START 199


/* Makroi za manipulaciju heksadekadnim ciframa */
#define TO_HEX_DIGIT(c) (c<10?c+'0':c-10+'A')

/* Tip podataka memorije */
typedef unsigned char byte;

/* Globalne promenljive */
int inst_len[]={2,2,2,1,2,2,2,2,1,2,2,1}; /* Duzine instrukcija */
char *instrukcije[]={"mua","aum","add","cpl","and","xor","shl","shr","halt","jz","adc","fua"};
struct simbol
{
  char *sim;
  byte addr;
  int label;
} *simboli[MAX_SIM];
int sim_no;
int var_no;


int lineno=1;
int byte_cnt;

int GetWord(FILE *f1, char *s, int max)
{
  int c,i,t;
  while(isspace(c=tolower(getc(f1))))
    if(c=='\n')
      lineno++;
  for (i=0; max>0 && !isspace(c) && c!=EOF; max--, c=tolower(getc(f1)))
    {
      if(c=='@' && i!=0)
	{
	  ungetc(c,f1);
	  break;
	}
      s[i++]=c;
      t=c;
    }
  s[i]='\0';
  if(c=='\n')
    ungetc(c,f1);
  if(c==EOF && i!=0)
    c=t;
  return c;
}

int GetVal(char *s, int *v)
{
  int broj;
  if((broj=atoi(s))==0)
    if(!(s[0]=='0' && s[1]=='\0' || (s[0]=='+' || s[0]=='-') && s[1]=='0' && s[2]=='\0'))
      {
	printf("Los broj na liniji %d!\n", lineno);
	return 0;
      }
  if(s[0]=='+' && broj>127 || s[0]=='-' && broj<-128 || isdigit(s[0]) && broj>255)
    {
      printf("Broj van opsega na liniji %d!\n", lineno);
      return 0;
    }
  if(v!=NULL)
    *v=broj;
  return 1;
}

int isname(char *s)
{
  int len;
  int i;
  if(!isalpha(s[0]))
    return 0;
  len=strlen(s);
  for(i=1; i<len; i++)
    if(!isalnum(s[i]) && s[i]!='_')
      return 0;
  return 1;
}

int AddSim(char *sim, int label, int addr)
{
  int i;
  int pos;
  if(label)
    sim[pos=(strlen(sim)-1)]='\0';
  if(!isname(sim))
    {
      printf("%s nije validno ime!\n",sim);
      return 0;
    }
  for(i=0; i<sim_no; i++)
    if(!strcmp(simboli[i]->sim,sim))
      {
	printf("Simbol %s je vec definisan!\n",sim);
	return 0;
      }
  ++sim_no;
  if(!label)
    var_no++;
  if(!label && var_no + SIM_START >= MEM_SIZE || sim_no >= MAX_SIM)
    {
      printf("Previse simbola! Simbol %s ne moze biti zapamcen!\n", sim);
      return 0;
    }
  simboli[sim_no-1]=(struct simbol *)malloc(sizeof(struct simbol));
  simboli[sim_no-1]->sim=strdup(sim);
  simboli[sim_no-1]->label=label;
  if(!label)
    simboli[sim_no-1]->addr=var_no + SIM_START;
  else
    simboli[sim_no-1]->addr=addr;
  if(label)
    sim[pos]=':';
  return 1;
}


struct simbol *GetSim(char *s)
{
  int i;
  for(i=0; i<sim_no; i++)
    if(!strcmp(simboli[i]->sim, s))
      return simboli[i];
  return NULL;
}

void BrisiSimbole(void)
{
  int i;
  for(i=0; i<sim_no; i++)
    {
      free(simboli[i]->sim);
      free(simboli[i]);
    }
}

int CheckAndWriteNo(char *s, int faza, FILE *f)
{
  if(faza==1 && !GetVal(s,NULL))
    return 0;
  else if(faza==2)
    {
      int v;
      GetVal(s,&v);
      if(v<0)
	v=AC_SIZE+v;
      fprintf(f,"%c%c",TO_HEX_DIGIT(v/16),TO_HEX_DIGIT(v%16));
    }
  return 1;
}

int CopyNumber(char *pos1, char *pos2, char *dest, int len)
{
  int i;
  char *temp=pos1;
  if(pos2-pos1+1 >= len)
    return 0;
  while(pos1<=pos2)
    {
      if(!isdigit(*pos1) && !(pos1==temp && *pos1=='-' || *pos1=='+'))
	{
	  printf("Los broj na liniji: %d!\n", lineno);
	  return 0;
	}
      *dest++=*pos1++;
    }
  *dest='\0';
  return 1;
}

int CheckAndWriteArg(char *s, int faza, FILE *f)
{
  int addr;
  int v;
  int len;
  char t[5];
  struct simbol *sim;

  sim=GetSim(s);

  if(sim!=NULL || faza==1 && isname(s))
    {
      if(faza==2)
	{
	  if(byte_cnt>156)
	    {
	      printf("Adresa za program van opsega: %d!\n",byte_cnt);
	      return 0;
	    }
	  fprintf(f,"%c%c%c",sim->label+'0',TO_HEX_DIGIT(sim->addr/16),TO_HEX_DIGIT(sim->addr%16));
	}
      return 1;
    }
  len=strlen(s);
  if(s[0]=='#' && CopyNumber(s+1,s+len-1,t,5) && GetVal(t,&v))
    {
      if(v<0)
	v=AC_SIZE+v;
      if(faza==2)
	{
	  if(byte_cnt>156)
	    {
	      printf("Adresa za program van opsega: %d!\n",byte_cnt);
	      return 0;
	    }
	  fprintf(f,"1%c%c",TO_HEX_DIGIT(v/16),TO_HEX_DIGIT(v%16));
	}
      return 1;
    }
  if(s[0]=='[' && s[len-1]==']' && CopyNumber(s+1,s+len-2,t,5) && GetVal(t,&v))
    {
      if(v<0)
	{
	  printf("Negativna adresa na liniji: %d!\n", lineno);
	  return 0;
	}
      if(v>199)
	{
	  printf("Pristup adresnom prostoru za promenljive na liniji: %d!\n",lineno);
	  return 0;
	}
      if(faza==2)
	{
	  if(byte_cnt>156)
	    {
	      printf("Adresa za program van opsega: %d!\n",byte_cnt);
	      return 0;
	    }
	  fprintf(f,"2%c%c",TO_HEX_DIGIT(v/16),TO_HEX_DIGIT(v%16));
	}
      return 1;
    }
  if(s[0]=='(' && s[len-1]==')' && CopyNumber(s+1,s+len-2,t,5) && GetVal(t,&v))
    {
      if(v<0)
	v=AC_SIZE+v;
      if(faza==2)
	{
	  if(byte_cnt>156)
	    {
	      printf("Adresa za program van opsega: %d!\n",byte_cnt);
	      return 0;
	    }
	  fprintf(f,"3%c%c",TO_HEX_DIGIT(v/16),TO_HEX_DIGIT(v%16));
	}
      return 1;
    }
  if(GetVal(s,&v))
    {
      if(v<0)
	{
	  printf("Negativna adresa na liniji: %d!\n", lineno);
	  return 0;
	}
      if(v>199)
	{
	  printf("Pristup adresnom prostoru za promenljive na liniji: %d!\n",lineno);
	  return 0;
	}
      if(faza==2)
	{
	  if(byte_cnt>156)
	    {
	      printf("Adresa za program van opsega: %d!\n",byte_cnt);
	      return 0;
	    }
	  fprintf(f,"0%c%c",TO_HEX_DIGIT(v/16),TO_HEX_DIGIT(v%16));
	}
      return 1;
    }
  return 0;
}

int Faza(int faza, FILE *f1, FILE *f2)
{
  int c;
  int v;
  int i;
  char s[MAX_WORD+1];
  int state=0;
  int broj;
  int l;
  int op_code;

  if(faza!=1 && faza!=2)
    {
      printf("Faza mora biti prva ili druga!\n");
      return 0;
    }
  while(GetWord(f1,s,MAX_WORD)!=EOF)
    {
      if(s[0]=='@')
	{
	  while((c=getc(f1))!=EOF && c!='\n');
	  if(c=='\n')
	    lineno++;
	  continue;
	}
      switch(state)
	{
	case 0:
	  if(!strcmp(".var",s))
	    {
	      if(faza==2)
		fprintf(f2,"\nC8 ");
	      state=1;
	    }
	  else if(!strcmp(".data",s))
	    {
	      if(faza==2)
		fprintf(f2,"\n");
	      state=6;
	    }
	  else if(!strcmp(".prg",s))
	    {
	      if(faza==2)
		fprintf(f2,"\n00 ");
	      state=2;
	    }
	  else
	    {
	      printf("Ocekivana je .var, .data ili .prg sekcija!\n");
	      return 0;
	    }
	  break;
	case 1:
	  if(!strcmp(".data",s))
	    {
	      if(faza==2)
		fprintf(f2,"\n");
	      state=6;
	    }
	  else if(!strcmp(".prg",s))
	    {
	      if(faza==2)
		fprintf(f2,"\n00 ");
	      state=2;
	    }
	  else
	    {
	      if(faza==1 && !AddSim(s,0,0))
		return 0;
	      state=3;
	    }
	  break;
	case 2:
	case 4:
	case 5:
	  if(s[l=(strlen(s)-1)]==':' && faza==1 && !AddSim(s,1,byte_cnt))
	    return -1;
	  else if(s[l]==':')
	    {
	      state=5;
	    }
	  else if(s[l]!=':')
	    {
	      for(i=0; i<sizeof(instrukcije)/sizeof(instrukcije[0]); i++)
		if(!strcmp(instrukcije[i],s))
		  {
		    if(state==4 && inst_len[op_code]==2)
		      {
			printf("Ocekivan je argument instrukcije na liniji: %d!\n", lineno);
			return 0;
		      }
		    if(byte_cnt>159)
		      {
			printf("Adresa za program van opsega: %d!\n",byte_cnt);
			return 0;
		      }
		    if(faza==2)
		      fprintf(f2,"%c",TO_HEX_DIGIT(i));
		    byte_cnt++;
		    if(inst_len[i]==1)
		      {
			if(byte_cnt>159)
			  {
			    printf("Adresa za program van opsega: %d!\n",byte_cnt);
			    return 0;
			  }
			if(faza==2)
			  fprintf(f2,"0");
		      }
		    state=4;
		    op_code=i;
		    break;
		  }
	      if(i==sizeof(instrukcije)/sizeof(instrukcije[0]))
		{
		  if(state==4 && inst_len[op_code]==2 && !CheckAndWriteArg(s,faza,f2))
		    {
		      printf("Los argument na liniji: %d!\n",lineno);
		      return 0;
		    }
		  else if(state==4 && inst_len[op_code]==2)
		    {
		      byte_cnt++;
		      state=2;
		    }
		  else
		    {
		      printf("Ocekivana je instrukcija ili oznaka na liniji: %d!\n",lineno);
		      return 0;
		    }
		}
	    }
	  break;
	case 3:
	  if(!CheckAndWriteNo(s,faza,f2))
	    return 0;
	  state=1;
	  break;
	case 6:
	  if(faza==1 && !GetVal(s,&v))
	    return 0;
	  else if(faza==1 && !(v>159 && v<=199))
	    {
	      printf("Greska na liniji %d. Prostor za podatke je od 160 do 199!\n", lineno);
	      return 0;
	    }
	  else if(faza==2)
	    {
	      GetVal(s,&v);
	      fprintf(f2,"%c%c ",TO_HEX_DIGIT(v/16),TO_HEX_DIGIT(v%16));
	    }
	  state=7;
	  break;
	case 7:
	  if(!strcmp(".prg",s))
	    {
	      if(faza==2)
		fprintf(f2,"\n00 ");
	      state=2;
	    }
	  else if(!strcmp(".data",s))
	    {
	      if(faza==2)
		fprintf(f2,"\n");
	      state=6;
	    }
	  else
	    {
	      if(v>199)
		{
		  printf("Adresa za podatak je van opsega: %d!\n",v);
		  return 0;
		}
	      if(CheckAndWriteNo(s,faza,f2)<0)
		return 0;
	      v++;
	    }
	  break;
	default:
	  printf("Nepoznato stanje: %d!\n",state);
	  return 0;
	  break;
	}
    }
  switch(state)
    {
    case 0:
      printf("Ocekivana je .var, .data ili .prg sekcija!\n");
      return 0;
      break;
    case 3:
      printf("Svaka promenljiva mora biti inicijlaizovana!\n");
      return 0;
      break;
    case 4:
      if(inst_len[op_code]==2)
	{
	  printf("Nedostajuci argument na liniji: %d!\n",lineno);
	  return 0;
	}
      return 1;
      break;
    case 6:
      printf(".data sekcija zahteva adresu!\n");
      return 0;
      break;
    default:
      return 1;
      break;
    }
}

int Prevod(FILE *f1, FILE *f2)
{
  byte_cnt = 0;
  if(!Faza(1,f1,f2))
    {
      BrisiSimbole();
      printf("Prva faza nije uspela!\n");
      return 0;
    }
  fseek(f1,0,SEEK_SET);
  lineno=1;
  byte_cnt = 0;
  if(!Faza(2,f1,f2))
    {
      BrisiSimbole();
      printf("Druga faza nije uspela!\n");
      return 0;
    }
  BrisiSimbole();
  return 1;
}

int main(int argc, char **argv)
{
  FILE *f1,*f2;
  if(argc<2)
    {
      printf("Uputstvo: asm2 ulaz_dat [izlaz_dat]\n");
      return -1;
    }
  if((f1=fopen(argv[1],"r"))==NULL)
    {
      printf("Fajl %s ne moze biti otvoren za citanje!\n",argv[1]);
      return -1;
    }
  if(argc>=3)
    {
      if(!strcmp(argv[1],argv[2]))
	{
	  printf("Fajl %s ne moze biti otvoren i za citanje i za pisanje!\n",argv[1]);
	  return -1;
	}
      if((f2=fopen(argv[2],"w"))==NULL)
	{
	  printf("Fajl %s ne moze biti otvoren za pisanje!\n",argv[2]);
	  return -1;
	}
    }
  else
    if((f2=fopen("a.out","w"))==NULL)
      {
	printf("Fajl a.out ne moze biti otvoren za pisanje!\n",argv[2]);
	return -1;
      }
  if(Prevod(f1,f2))
    printf("Prevodjenje je uspelo!\n");
  else
    {
      printf("Prevodjenje nije uspelo!\n");
      return -1;
    }
  fclose(f1);
  fclose(f2);
  return 0;
}
