#include <stdio.h>
#include <ctype.h>
#include <string.h>

#define MEM_SIZE 256 /* Velicina memorije */
#define AC_SIZE  256 /* Raspon vrednosti akumulatora */
#define NAME_LEN 80  /* Maksimalna duzina imena datoteke */

/* Operacioni kodovi instrukcija */
#define MUA  0x00 /* Memorija u akumulator */
#define AUM  0x01 /* Akumulator u memoriju */
#define ADD  0x02 /* Sabiranje */
#define CPL  0x03 /* Potpuni komplement */
#define AND  0x04 /* Bitska konjunkcija */
#define XOR  0x05 /* Bitsko ekskluzivno ili */
#define SHL  0x06 /* Pomeranje akumulatora ulevo */
#define SHR  0x07 /* Aritmeticko pomeranje akumulatora udesno */
#define HALT 0x08 /* Zaustavljanje izvrsavanja */
#define JZ   0x09 /* Skok ako je postavljen zero flag */
#define ADDC 0x0A /* Sabiranje ukljucujuci prenos */
#define FUA  0x0B /* Flag-ovi u akumulator */

/* Nacini adresiranja */
#define DIRECT    0x00 /* Direktno adresiranje */
#define IMMEDIATE 0x01 /* Neposredno adresiranje */
#define INDIRECT  0x02 /* Indirektno adresiranje */
#define RELATIVE  0x03 /* Relativno adresiranje */

/* Maske */
#define ADDR_MODE_MASK 0x03 /* Maska za izdvajanje nacina adresiranja */

/* Nacini izvrsavanja */
#define RUN      0 /* Kompletno izvrsavanje */
#define STEP     1 /* Izvrsavanje jednog koraka */

#define DATA 0
#define PROGRAM 1
#define UNDEFINED -1

/* Makroi za manipulaciju heksadekadnim ciframa */
#define IS_HEX(c) (isdigit(c) || tolower(c) >= 'a' && tolower(c) <= 'f')
#define HEX_VALUE(c) (isdigit(c)?c-'0':tolower(c)-'a'+10)
#define TO_HEX_DIGIT(c) (c<10?c+'0':c-10+'A')

/* Tip podataka memorije */
typedef unsigned char byte;

/* Globalne promenljive */
byte memory[MEM_SIZE]; /* Memorija */
int inst_len[]={2,2,2,1,2,2,2,2,1,2,2,1}; /* Duzine instrukcija */
int breakpts[MEM_SIZE]; /* Logicki niz koji odredjuje postojanje breakpoint-a */
char *instrukcije[]={"mua","aum","add","cpl","and","xor","shl","shr","halt","jz","adc","fua"};

byte ic; /* Brojac instrukcija (instruction counter) */
byte ac; /* Akumulator (Accumulator) */

/* Flag-ovi */
struct
{
  byte v : 1; /* Overflow - prekoracenje kod oznacenog sabiranja */
  byte s : 1; /* Sign - znak vrednosti akumulatora */
  byte z : 1; /* Zero - akumulator==0 */
  byte c : 1; /* Carry - prekoracenje (prenos) kod neoznacenog sabiranja */
} flags;

int Prevod(FILE *f1, FILE *f2)
{
  int eof=0;
  int c;
  int lineno=1;
  int state=UNDEFINED;
  int addr;
  while(!eof)
    {
      while((c=tolower(fgetc(f1)))!=EOF && isspace(c))
	if(c=='\n')
	  lineno++;
      if(c==EOF)
        {
	  eof=1;
	  continue;
        }
      else if(c=='@')
        {
	  while((c=tolower(fgetc(f1)))!=EOF && c!='\n');
	  if(c==EOF)
            {
	      eof=1;
	      continue;
            }
	  else
	    lineno++;
        }
      else if(state==PROGRAM)
        {
	  char s[6];
	  int i;
	  int op_code=-1;
	  int addr_mode=-1;
	  char sign;
	  int num;
	  if(c=='.')
            {
	      int num;
	      for(i=0; i<3; i++)
                {
		  s[i]=tolower(fgetc(f1));
		  if(s[i]=='\n')
		    lineno++;
                }
	      s[i]='\0';
	      if(strcmp(s,"prg"))
                {
		  printf("U okviru program sekcije dozvoljene su komande i .prg direktiva!\n");
		  return -1;
                }
	      while((c=tolower(fgetc(f1)))!=EOF && isspace(c))
		if(c=='\n')
		  lineno++;
	      if(c==EOF)
		{
		  eof=1;
		  continue;
		}
	      for(num=0,i=0; isdigit(c); c=tolower(fgetc(f1)),i++)
		num=10*num+(c-'0');
	      if(c=='\n')
                {
		  lineno++;
		  while((c=tolower(fgetc(f1)))!=EOF && isspace(c))
		    if(c=='\n')
		      lineno++;
                }
	      if(i==0 || num>155)
		{
		  printf("Los argument na liniji %d!\n", lineno);
		  return -1;
		}
	      if(i>3)
		{
		  printf("Prekoracenje na liniji %d: %c%d!\n",lineno,num);
		  return -1;
		}
	      fprintf(f2,"\n%c%c ",TO_HEX_DIGIT(num/16),TO_HEX_DIGIT(num%16));
	      addr=num;
            }
	  s[0]=tolower(c);
	  s[1]=tolower(fgetc(f1));
	  if(s[1]=='\n')
	    lineno++;
	  s[2]='\0';
	  if(!strcmp(s,instrukcije[JZ]))
	    op_code=JZ;
	  else
            {
	      s[2]=tolower(fgetc(f1));
	      if(s[2]=='\n')
		lineno++;
	      s[3]='\0';
	      for(i=0; i<sizeof(instrukcije)/sizeof(instrukcije[0]); i++)
		if(!strcmp(s,instrukcije[i]))
		  {
		    op_code=i;
		    break;
		  }
	      if(op_code==-1)
                {
		  s[3]=tolower(fgetc(f1));
		  if(s[3]=='\n')
		    lineno++;
		  s[4]='\0';
		  if(!strcmp(s,instrukcije[HALT]))
		    op_code=HALT;
		  if(op_code==-1)
                    {
		      printf("Nepoznat kod instrukcije na liniji %d: %s\n",lineno,s);
		      return -1;
                    }
                }
            }
	  if(op_code==HALT)
            {
	      fprintf(f2,"80");
	      continue;
            }
	  if(op_code!=CPL && op_code!=FUA)
            {
	      while((c=tolower(fgetc(f1)))!=EOF && isspace(c))
		if(c=='\n')
		  lineno++;
	      switch(c)
		{
		case '#':
		  addr_mode=IMMEDIATE;
		  while((c=tolower(fgetc(f1)))=='\n')
		    lineno++;
		  break;
		case '[':
		  addr_mode=INDIRECT;
		  while((c=tolower(fgetc(f1)))=='\n')
		    lineno++;
		  break;
		case '(':
		  addr_mode=RELATIVE;
		  while((c=tolower(fgetc(f1)))=='\n')
		    lineno++;
		  break;
		default:
		  if(isdigit(c) || c=='+' || c=='-')
		    addr_mode=DIRECT;
		  else
		    {
		      printf("Los argument na liniji %d!\n", lineno);
		      return -1;
		    }
		  break;
		}
	      sign=0;
	      if(c=='+' || c=='-')
		{
		  if(addr_mode!=IMMEDIATE && addr_mode!=RELATIVE)
		    {
		      printf("Los argument na liniji %d!\n",lineno);
		      return -1;
		    }
		  sign=c;
		  while((c=tolower(fgetc(f1)))!=EOF && isspace(c))
		    if(c=='\n')
		      lineno++;
		}
	      for(num=0,i=0; isdigit(c); c=tolower(fgetc(f1)),i++)
		num=10*num+(c-'0');
	      if(i==0)
		{
		  printf("Los argument na liniji %d!\n", lineno);
		  return -1;
		}
	      if((i>3) || (sign==0) && (num>255) || (sign=='+') && (num>127) ||
		 (sign=='-') && (num>128))
		{
		  printf("Prekoracenje na liniji %d: %c%d!\n",lineno,sign?sign:' ',num);
		  return -1;
		}
	      num=(sign=='-'?AC_SIZE-num:num);
	      if(addr_mode==IMMEDIATE || addr_mode==DIRECT)
		{
		  if(!isspace(c) && c!=EOF)
		    {
		      printf("Los argument na liniji %d!\n", lineno);
		      return -1;
		    }
                }
	      else if(addr_mode==RELATIVE)
		{
		  if(c!=')')
		    {
		      printf("Los argument na liniji %d!\n", lineno);
		      return -1;
		    }
		}
	      else
		{
		  if(c!=']')
		    {
		      printf("Los argument na liniji %d!\n", lineno);
		      return -1;
		    }
		}
	      if(c=='\n')
		lineno++;
            }
	  if(addr>155)
            {
	      printf("Program je predug!\n");
	      return -1;
            }
	  if(op_code==CPL || op_code==FUA)
	    addr_mode=0;
	  fprintf(f2,"%c%c",TO_HEX_DIGIT(op_code),TO_HEX_DIGIT(addr_mode));
	  addr++;
	  if(op_code!=CPL && op_code!=FUA)
            {
	      if(addr>155)
		{
		  printf("Program je predug!\n");
		  return -1;
		}
	      fprintf(f2,"%c%c",(num/16<10)?num/16+'0':num/16-10+'A',(num%16<10)?num%16+'0':num%16-10+'A');
	      addr++;
            }
        }
      else if(state==DATA)
        {
	  int i;
	  char s[6];
	  if(c=='.')
            {
	      for(i=0; i<3; i++)
                {
		  s[i]=tolower(fgetc(f1));
		  if(s[i]=='\n')
		    lineno++;
                }
	      s[i]='\0';
	      if(strcmp(s,"prg"))
		{
		  int num;
		  s[i++]=tolower(fgetc(f1));
		  if(s[i-1]=='\n')
		    lineno++;
		  s[i]='\0';
		  if(strcmp(s,"data"))
                    {
		      printf("Posle '.' ocekuje se prg ili data!\n");
		      return -1;
                    }
		  state=DATA;
		  while((c=tolower(fgetc(f1)))!=EOF && isspace(c))
		    if(c=='\n')
		      lineno++;
		  for(num=0,i=0; isdigit(c); c=tolower(fgetc(f1)),i++)
		    num=10*num+(c-'0');
		  if(c=='\n')
		    lineno++;
		  if(i==0 || num<155)
		    {
		      printf("Los argument na liniji %d!\n", lineno);
		      return -1;
		    }
		  if((i>3) || (num>255))
		    {
		      printf("Prekoracenje na liniji %d: %c%d!\n",lineno,num);
		      return -1;
		    }
		  fprintf(f2,"\n%c%c ",TO_HEX_DIGIT(num/16),TO_HEX_DIGIT(num%16));
		  addr=num;
		}
	      else
		{
		  int num;
		  state=PROGRAM;
		  while((c=tolower(fgetc(f1)))!=EOF && isspace(c))
		    if(c=='\n')
		      lineno++;
		  for(num=0,i=0; isdigit(c); c=tolower(fgetc(f1)),i++)
		    num=10*num+(c-'0');
		  if(c=='\n')
		    lineno++;
		  if(i==0)
		    {
		      printf("Los argument na liniji %d!\n", lineno);
		      return -1;
		    }
		  if((i>3) || num>155)
		    {
		      printf("Prekoracenje na liniji %d: %c%d!\n",lineno,num);
		      return -1;
		    }
		  fprintf(f2,"\n%c%c ",TO_HEX_DIGIT(num/16),TO_HEX_DIGIT(num%16));
		  addr=num;
		}
            }
	  else
            {
	      int num;
	      int sign=0;
	      if(c=='+' || c=='-')
		{
		  sign=c;
		  while((c=tolower(fgetc(f1)))!=EOF && isspace(c))
		    if(c=='\n')
		      lineno++;
		}
	      for(num=0,i=0; isdigit(c); c=tolower(fgetc(f1)),i++)
		num=10*num+(c-'0');
	      if(i==0)
		{
		  printf("Los argument na liniji %d!\n", lineno);
		  return -1;
		}
	      if(c=='\n')
		lineno++;
	      if((i>3) || (sign==0) && (num>255) || (sign=='+') && (num>127) ||
		 (sign=='-') && (num>128))
		{
		  printf("Prekoracenje na liniji %d: %c%d!\n",lineno,sign?sign:' ',num);
		  return -1;
		}
	      if(addr>255)
		{
		  printf("Sekcija podataka je preduga!\n");
		  return -1;
		}
	      num=(sign=='-'?AC_SIZE-num:num);
	      fprintf(f2,"%c%c",TO_HEX_DIGIT(num/16),TO_HEX_DIGIT(num%16));
	      addr++;
            }
        }
      else if(state==UNDEFINED)
        {
	  char s[5];
	  int i;
	  if(c!='.')
            {
	      printf("Neophodne su instrukcije .data ili .prg!\n");
	      return -1;
            }
	  for(i=0; i<3; i++)
            {
	      s[i]=tolower(fgetc(f1));
	      if(s[i]=='\n')
		lineno++;
            }
	  s[i]='\0';
	  if(strcmp(s,"prg"))
            {
	      s[3]=tolower(fgetc(f1));
	      if(s[3]=='\n')
		lineno++;
	      s[4]='\0';
	      if(!strcmp(s,"data"))
                {
		  int num;
		  state=DATA;
		  while((c=tolower(fgetc(f1)))!=EOF && isspace(c))
		    if(c=='\n')
		      lineno++;
		  for(num=0,i=0; isdigit(c); c=tolower(fgetc(f1)),i++)
		    num=10*num+(c-'0');
		  if(c=='\n')
		    lineno++;
		  if(i==0 || num<155)
		    {
		      printf("Los argument na liniji %d!\n", lineno);
		      return -1;
		    }
		  if((i>3) || (num>255))
		    {
		      printf("Prekoracenje na liniji %d: %c%d!\n",lineno,num);
		      return -1;
		    }
		  fprintf(f2,"\n%c%c ",TO_HEX_DIGIT(num/16),TO_HEX_DIGIT(num%16));
		  addr=num;
		  continue;
                }
	      else
                {
		  printf("Neophodne su instrukcije .data ili .prg!\n");
		  return -1;
                }
            }
	  else
            {
	      int num;
	      state=PROGRAM;
	      while((c=tolower(fgetc(f1)))!=EOF && isspace(c))
		if(c=='\n')
		  lineno++;
	      for(num=0,i=0; isdigit(c); c=tolower(fgetc(f1)),i++)
		num=10*num+(c-'0');
	      if(c=='\n')
		lineno++;
	      if(i==0 || num>155)
		{
		  printf("Los argument na liniji %d!\n", lineno);
		  return -1;
		}
	      if(i>3)
		{
		  printf("Prekoracenje na liniji %d: %c%d!\n",lineno,num);
		  return -1;
		}
	      fprintf(f2,"\n%c%c ",TO_HEX_DIGIT(num/16),TO_HEX_DIGIT(num%16));
	      addr=num;
	      continue;
            }
        }
    }
  return 0;
}

int main(int argc, char **argv)
{
  FILE *f1,*f2;
  if(argc<2)
    {
      printf("Uputstvo: asm ulaz_dat [izlaz_dat]\n");
      return -1;
    }
  if((f1=fopen(argv[1],"r"))==NULL)
    {
      printf("Fajl %s ne moze biti otvoren za citanje!\n",argv[1]);
      return -1;
    }
  if(argc>=3)
    {
      if(!strcmp(argv[1],argv[2]))
        {
	  printf("Fajl %s ne moze biti otvoren i za citanje i za pisanje!\n",argv[1]);
	  return -1;
        }
      if((f2=fopen(argv[2],"w"))==NULL)
        {
	  printf("Fajl %s ne moze biti otvoren za pisanje!\n",argv[2]);
	  return -1;
        }
    }
  else
    if((f2=fopen("a.out","w"))==NULL)
      {
	printf("Fajl a.out ne moze biti otvoren za pisanje!\n",argv[2]);
	return -1;
      }
  if(!Prevod(f1,f2))
    printf("Prevodjenje je uspelo!\n");
  else
    {
      printf("Prevodjenje nije uspelo!\n");
      return -1;
    }
  fclose(f1);
  fclose(f2);
  return 0;
}
