#include <stdio.h>

/* NAPOMENA: 

   String (ili niska) je podatak koji sadrzi sekvencu karaktera. Koristi
   se za predstavljanje tekstualnih podataka. U C-u ne postoji poseban
   tip za stringove, vec se oni predstavljaju kao niz karaktera, s tim
   sto je obavezno da se u tom nizu nakon sekvence karaktera koje cine
   string nalazi i specijalni kontrolni karakter -- terminirajuca nula.
   U pitanju je karakter ciji je ASCII kod jednak nuli. Moze se navesti
   ili kao celobrojna konstanta 0, ili kao specijalna karakterska 
   konstanta '\0'. Treba, naravno praviti razliku izmedju ovog karaktera
   i karaktera '0' koji predstavlja dekadnu cifru ciji je ASCII kod 48.
   Dakle:
   
   0 == '\0' != '0' == 48    

   String se moze definisati ili tako sto se definise niz, pa se njegovi
   elementi inicijalizuju na odgovarajuci nacin:

   char s[] = {'a', 'b', 'c', '\0'};

   Obratiti paznju na terminirajucu nulu, koja se ne sme zaboraviti.
   Drugi (bolji) nacin je koriscenje stringovskih konstanti (koje
   se navode izmedju dvostrukih navodnika):

   char s[] = "abc";

   Ovo je ekvivalentno sa gornjom definicijom (prevodilac automatski 
   dodaje i terminirajucu nulu). U oba slucaja je niz s duzine 4, 
   pri cemu se prva tri elementa niza inicijalizuju karakterima 'a'
   'b', 'c', a u poslednjem elementu niza se nalazi terminirajuca
   nula. 

   Sustinski drugacija definicija stringa je:

   char * s = "abc";

   Ovim se definise pokazivac na karakter, koji se inicijalizuje adresom
   prvog karaktera u stringu "abc" (koji je konstantan, i nalazi se negde
   u memoriji). Promenljivu s je moguce menjati (cak je "preusmeriti" da
   pokazuje na nesto sasvim drugo), ali nije moguce menjati karaktere 
   stringa "abc", koji je konstantan. Sa druge strane, u prethodnim 
   definicijama definisemo niz karaktera, ciji se elementi inicijalizuju
   na odgovarajuci nacin, ali ih je kasnije moguce menjati. Samim tim,
   string koji se nalazi u tom nizu nije konstantan. Sa druge strane, 
   s obzirom da je u tom slucaju s ime niza, nije dozvoljeno primenjivati
   bocne efekte tipa s++, ili s = t.

   Lepa osobina stringa je da je adresa njegovog pocetka jedina informacija
   koja nam je potrebna da bismo radili sa njim (s obzirom da je njegov
   kraj implicitno odredjen terminirajucom nulom). Zbog toga vecina funkcija
   za rad sa stringovima kao argument prihvataju samo adresu pocetka stringa.
   Takodje, s obzirom da se stringovi predstavljaju nizovima karaktera, 
   oni se funkcijama uvek prenose po adresi, pa samim tim funkcija moze
   u svom telu modifikovati originalni string.

   Stringovi se mogu ucitavati/ispisivati na vise nacina:

   1) Pomocu scanf() funkcije (%s specifikator, ucitava do prve beline),
   odnosno pomocu printf() funkcije (takodje %s).
   2) Karakter po karakter, kroz petlju (getchar/putchar)
   3) Pomocu funkcija fgets() i fputs() za ucitavanje i ispis celih linija
   (ovo ce biti radjeno u drugom semestru)
*/
   

/* Funkcija izracunava duzinu stringa (terminirajuca nula se ne broji,
   jer se ona ne smatra delom stringa, vec oznacava njegov kraj) */
int duzina(char * s)
{
  int i;
  
  for(i = 0; s[i] != '\0'; i++);
   
  return i;
}

/* Druga verzija */
int duzina2(char * s)
{
  int i = 0;
  
  while(s[i++] != '\0');
   
  return i - 1;
}

/* Treca verzija */
int duzina3(char * s)
{
  int i = 0;
  
  while(*s++ != '\0') i++;
   
  return i;
}

/* Cetvrta verzija */
int duzina4(char * s)
{
  char * p = s;
  
  while(*s++ != '\0');
   
  return s - p - 1;
}

/* Funkcija leksikografski uporedjuje stringove. Vraca > 0 ako je prvi
   veci, <0 ako je prvi manji, a 0 ako su identicki jednaki */
int uporedi(char * s, char * t)
{
  int i;

  for(i = 0; s[i] == t[i]; i++)
    {
      if(s[i] == '\0')
	break;
    }
  
  return s[i] - t[i];
}

/* Druga verzija */
int uporedi2(char * s, char * t)
{

  for(; *s == *t; s++, t++)
    {
      if(*s == '\0')
	break;
    }
  
  return *s - *t;
}

/* Funkcija kopira string na ciji pocetak pokazuje t u 
   niz na ciji pocetak pokazuje s */
void kopiraj(char * s, char * t)
{
  int i;

  for(i = 0; t[i] != '\0'; i++)
    s[i] = t[i];

  s[i] = '\0'; /* Jako bitno!! Ne zaboraviti!! */
}

/* Funkcija nadovezuje string t na string s */
void nadovezi(char * s, char * t)
{
  int i;

  while(*s != '\0') s++;
  
  kopiraj(s, t);
}

/* NAPOMENA: Zaglavlje string.h sadrzi veliki broj korisnih funkcija
   za rad sa stringovima:
 
   -- int strlen(char *s); vraca duzinu stringa (kao nasa funkcija duzina())
   -- char * strcpy(char * s, char *t); kopira string t u niz na koji pokazuje
   s (kao nasa funkcija kopiraj()). Niz na koji pokazuje s mora biti dovoljno
   veliki da prihvati string t (sa sve terminirajucom nulom).
   -- int strcmp(char *s, char *t); poredi leksikografski s i t (potpuno isto
   kao nasa funkcija uporedi())
   -- char * strcat(char * s, char *t); nadovezuje string t na string u 
   nizu s (isto kao nasa funkcija nadovezi()). Niz na koji pokazuje s mora 
   biti dovoljno veliki da prihvati rezultujuci string. 
   -- char * strstr(char * s, char * t); trazi prvu pojavu stringa t (kao 
   faktora) u stringu s. Vraca adresu pocetka tog faktora u s, ili konstantu
   NULL ako takav faktor ne postoji. (Konstanta NULL je definisana kao 0, 
   koristi se kao pokazivac koji ne pokazuje ni na sta).
   -- char * strchr(char * s, int c); trazi prvu pojavu karaktera c u 
   stringu s. Vraca adresu tog karaktera u stringu s (ili NULL ako takvog
   karaktera nema).
   -- char * strrchr(char * s, int c); trazi poslednju pojavu karaktera c
   u stringu s. Vraca adresu tog karaktera u stringu s (ili NULL ako takvog
   karaktera nema).
   -- char *strncpy(char * s, char * t, int n); radi isto sto i strcpy(), s tim
   sto kopira najvise n karaktera (racunajuci i terminirajucu nulu). Ovo je
   dobro, zato sto se tako moze spreciti da se "prepuni" rezultujuci niz.
   -- int strncmp(char * s, char * t, int n); isto kao i strcmp(), s tim sto
   poredi najvise prvih n karaktera. Ovo je zgodno ako zelimo da npr. poredimo
   da li im se poklapaju prefiksi date duzine.
   -- int strncat(char *s, char * t, int n); isto kao i strcat(), s tim sto 
   nadovezuje najvise prvih n karaktera stringa t na string s, a zatim upisuje
   terminirajucu nulu.

   Ove funkcije je dozvoljeno koristiti na ispitu (osim ako zadatak nije da se
   implementira bas ta funkcija, ili ako u tekstu zadatka nije drugacije 
   receno). 
 */



int main()
{
  /* Niz duzine 100, prvih 7 elemenata je inicijalizovano karakterima stringa
     i terminirajucom nulom */
  char s[100] = {'S', 't', 'r', 'i', 'n', 'g', '\0'}; 
  
  /* Niz inicijalizovan string konstantom (ovo implicitno ukljucuje i 
     terminirajucu nulu). Duzina niza nije navedena, pa se automatski
     odredjuje na osnovu inicijalizacije (12 elemenata). */
  char r[] = "abcdefghijk"; 

  /* Deklaracija pokazivacke promenljive t koja se inicijalizuje adresom
     konstantnog stringa */
  char *t = "abcdefghijk";

  int i;
  int c;

  /* Unos stringa s karakter po karakter */
  i = 0;
  while((c = getchar()) != EOF)
    s[i++] = c;
  s[i] = '\0'; /* Obavezno dodavanje terminirajuce nule */
  
  /* Ispis stringa karakter po karakter */
  for(i = 0; s[i] != '\0'; i++)
    putchar(s[i]);
  putchar('\n');
  
  /* Unos stringa pomocu scanf()-a (ucitavaju se karakteri do prve beline).
     Obratite paznju da ne navodimo &s, vec samo s, zato sto je ime niza
     samo po sebi adresa pocetnog karaktera u nizu. scanf() automatski
     dodaje terminirajucu nulu na kraju stringa. */
  scanf("%s", s);

  /* Ispis stringa i njegove duzine pomocu printf-a */
  printf("Duzina stringa %s je: %d\n", s, duzina4(s));
  
  /* Leksikografsko uporedjivanje stringova s i t */
  i = uporedi(s, t);

  if(i > 0)
    printf("String %s je veci od stringa %s\n", s, t);
  else if(i < 0)
    printf("String %s je manji od stringa %s\n", s, t);
  else
    printf("Stringovi %s i %s su jednaki\n", s, t);
  
  /* Nadovezivanje stringa t na s */
  nadovezi(s, t);

  printf("String nakon nadovezivanja: %s\n", s);

  return 0;
}
