.intel_syntax noprefix
		
.data
rdfmt:	.asciz  "%d"		# Ulazni format.
wrfmt:	.asciz  "%d\n"		# Izlazni format.

.bss
.lcomm	value, 4		# Lokacija za smjestanje ucitanih podataka.
		
.text
.global main

main:
	## Prolog funkcije.
	enter   0, 0
	pusha

	## Ucitava se duzina vektora. Duzina se stavlja u registar ecx,
	## koji ce drzati broj elemenata vektora koje jos treba
	## ucitati. Pretpostavka je da ce duzina vektora biti
	## nenegativan broj.
	lea	eax, value
	push	eax
	lea	eax, rdfmt
	push	eax
	call scanf
	add	esp, 8
	mov	ecx, value

	## Tekuca vrijednost uniformne norme ce biti drzana u registru
	## ebx. Inicijalizuje se sadrzaj ovog registra na 0 i provjerava
	## da li je duzina vektora veca od 0.
	xor	ebx, ebx
	jecxz print
	
next_element:
	## Ucitava se naredni element. Brojac se tokom ucitavanja cuva
	## na steku zato sto scanf() funkcija unistava sadrzaj ecx
	## registra.
	push	ecx
	lea	eax, value
	push	eax
	lea	eax, rdfmt
	push	eax
	call scanf
	add	esp, 8
	pop	ecx

	## Izracunava se apsolutna vrijednost elementa i poredi sa
	## tekucom vrijednoscu norme. Vrijednost norme se u skladu sa
	## ovim poredjenjem eventualno postavlja na apsolutnu vrijednost
	## elementa.
	mov	eax, value
	cmp	eax, 0
	jge compare
	neg	eax
compare:
	cmp	eax, ebx
	jng continue
	mov	ebx, eax

continue:
	## Nastavlja se sa petljom.
	loop next_element

print:
	## Ispisuje se vrijednost norme na standardni izlaz.
	push	ebx
	lea	eax, wrfmt
	push	eax
	call printf
	add	esp, 8
 	
	## Epilog funkcije.
	popa
	xor	eax, eax
	leave
	ret	
