.intel_syntax noprefix

.data
rdfmt:	.asciz  "%d"		# Ulazni format.
wrfmt:	.asciz  "%d\n"		# Izlazni format.

.bss
.lcomm	value, 4		# Lokacija za smjestanje ucitanih podataka.
			
.text
.global main

main:
        ## Prolog funkcije.
	enter	0, 0
	pusha

	## Ucitava se dimenzija matrice i prebacuje u registar
	## edx. Pretpostavka je da ce ova dimenzija biti nenegativan
	## broj.
	lea	eax, value
	push	eax
	lea	eax, rdfmt
	push	eax
	call scanf
	add	esp, 8
	mov	edx, value

	## Tekuca vrijednost uniformne norme ce biti drzana u registru
	## edi. Inicijalizuje se sadrzaj ovog registra na 0 i provjerava
	## da li je dimenzija matrice veca od 0.
	xor	edi, edi
	cmp	edx, 0
	je print

	## U spoljasnjoj petlji se prolazi kroz sve redove matrice,
	## izracunava se suma apsolutnih vrijednosti njihovih elemenata i
	## poredi sa tekucom vrijednoscu norme, pa se eventualno norma
	## postavlja na vrijednost ove sume. Suma apsolutnih vrijednosti
	## elemenata reda se drzi u registru ebx koji se inicijalizuje na
	## 0. Registar ecx se koristi kao brojac u spoljasnjoj petlji,
	## ali takodje i u unutrasnoj petlji. Zato se njegova vrijednost
	## prije ulaska u unutrasnju petlju cuva na steku, a potom
	## incijalizuje na dimenziju matrice.
	mov	ecx, edx
next_row:
	push	ecx
	mov	ecx, edx
	xor	ebx, ebx
	
next_element:
	## U unutrasnjoj petlji se prvo ucitava naredni
	## element. Sadrzaji registara ecx i edx se tokom ucitavanja
	## cuvaju na steku zato sto ih scanf() funkcija unistava.
	push	ecx
	push	edx
	lea	eax, value
	push	eax
	lea	eax, rdfmt
	push	eax
	call scanf
	add	esp, 8
	pop	edx
	pop	ecx

	## Potom se izracunava apsolutna vrijednost elementa i dodaje
	## sumi apsolutnih vrijednosti elemenata tekuceg reda.
	mov	eax, value
	cmp	eax, 0
	jge addition
	neg	eax
addition:
	add	ebx, eax
	loop next_element

	## Poredi se suma apsolutnih vrijednosti elemenata tekuceg reda
	## sa tekucom vrijednoscu norme i eventualno se postavlja
	## vrijednost norme na ovu sumu. Skida se sa steka vrijednost
	## brojaca za spoljasnju petlji i prelazi se na naredni red.
	cmp	edi, ebx
	jge continue
	mov	edi, ebx
continue:
	pop	ecx
	loop next_row

print:
	## Ispisuje se vrijednost norme na standardni izlaz.
	push	edi
	lea	eax, wrfmt
	push	eax
	call printf
	add	esp, 8
		
	## Epilog funkcije.
	popa
	xor	eax, eax
	leave
        ret
