.intel_syntax noprefix
		
.data
rdfmt:	.asciz  "%d"		# Ulazni format.
msg:	.asciz  "y\n"		# Izlazna poruka.

.bss
.lcomm	value, 4		# Lokacija za smjestanje ucitanih podataka.
		
.text
.global main

main:
	## Prolog funkcije.
        enter   0, 0
        pusha

	## Ucitava se element koji se trazi i smjesta u registar ebx.
	lea	eax, value
	push	eax
	lea	eax, rdfmt
	push	eax
	call scanf
	add	esp, 8
	mov	ebx, value
	
	## Ucitava se duzina polja i smjesta u registar ecx, koji ce
	## drzati broj preostalih elemenata. Pretpostavka je da ce
	## duzina polja biti nenegativan broj.
	lea	eax, value
	push	eax
	lea	eax, rdfmt
	push	eax
	call scanf
	add	esp, 8
	mov	ecx, value

	## Provjerava se da li je duzina polja veca od 0.
	jecxz done

next_element:
	## Ucitava se jedan po jedan element polja i poredi sa trazenim
	## elementom. Broj elemenata koji je preostao da se ucita se u
	## medjuvremenu cuva na steku zato sto scanf() funkcija unistava
	## sadrzaj ecx registra.
	push	ecx
	lea	eax, value
	push	eax
	lea	eax, rdfmt
	push	eax
	call scanf
	add	esp, 8
	pop	ecx

	## Poredi se trazeni element sa tekucim i, ukoliko su razliciti,
	## nastavlja se sa petljom.
	cmp	ebx, value
	loopne next_element

	## Ukoliko se iz petlje izaslo zato sto su ucitani svi elementi,
	## zavrsava se funkcija.
	jne done

	## U suprotnom se stampa poruka da je trazeni element pronadjen.
	lea	eax, msg
	push	eax
	call printf
	add	esp, 4

done:
	## Epilog funkcije.
	popa
	xor	eax, eax
	leave
	ret	
