.intel_syntax noprefix
		
.data
rdfmt:	.asciz  "%d%c%d"	# Ulazni format.
wrfmt:	.asciz  "%d\n"		# Izlazni format.

.bss
.lcomm	x, 4			# Prvi operand.
.lcomm	op, 1			# Operator.
.lcomm	y, 4			# Drugi operand.
		
.text
.global main

main:
	## Prolog funkcije.
	enter   0, 0
	pusha

	## Ucitava se izraz.
again:
	lea	eax, y
	push	eax
	lea	eax, op
	push	eax
	lea	eax, x
	push	eax
	lea	eax, rdfmt
	push	eax
	call scanf
	add	esp, 16

	## Odredjuje se koja je operacija u pitanju.
	mov	al, op
	cmp	al, '+'
	je addition
	cmp	al, '-'
	je subtraction
	cmp	al, '*'
	je multiplication
	cmp	al, '/'
	je division
	jmp again

	## Izracunava se zbir.
addition:
	mov	eax, x
	add	eax, y
	jmp print

	## Izracunava se razlika.
subtraction:
	mov	eax, x
	sub	eax, y
	jmp print

	## Izracunava se proizvod (smatra se da ce proizvod stati u 32
	## bita).
multiplication:
	mov	eax, x
	imul	dword ptr y
	jmp print

	## Izracunava se kolicnik.
division:
	mov	eax, x
	cdq
	idiv	dword ptr y

	## Stampa se rezultat i prelazi se na ucitavanje narednog
	## izraza.
print:
	push	eax
	lea	eax, wrfmt
	push	eax
	call printf
	add	esp, 8
	jmp again
 	
	## Epilog funkcije.
	popa
	xor	eax, eax
	leave
	ret
