.intel_syntax noprefix


.text
.global sort_strings

###########################################################################
##
## Funkcija sortira niz stringova u rastucem leksikografskom poretku, metodom
## izbora najveceg elementa. 
##	
## void sort_strings(char ** s, int n);
##
## -- char ** s   -- [ebp+8]  -- pokazivac na niz pokazivaca na stringove
## -- int n       -- [ebp+12] -- duzina niza
##
##########################################################################

sort_strings:
	## Prolog funkcije
	enter 0,0
	push edi
	push esi
	push ebx

	## Postavljamo smer kretanja kroz stringove (sa leva u desno)
	cld

	## U edx ucitavamo adresu niza pokazivaca, a u ecx duzinu niza n.
	mov edx, [ebp+8]
	mov ecx, [ebp+12]

	## Prazan niz nema smisla sortirati.
	jecxz done
	
	## Glavna petlja u kojoj se sortira niz pokazivaca u skladu sa
	## rastucim leksikografskim poretkom stringova na koje pokazuju.
	## Vrednost brojaca k u petlji nalazi se u registru ecx i ide od
	## n do 1.
main_loop:	

	## Postavljamo na stek vrednost k, zato sto cemo registar ecx
	## koristiti kao brojac unutrasnje petlje.
	push ecx

	## Umanjujemo ecx. Sada sadrzi vrednost k - 1. To je broj iteracija
	## koliko je potrebno u unutrasnjoj petlji. Takodje, to je vrednost
	## indeksa elementa koji se inicijalno proglasava za najveci element.
	## Vrednost indeksa elementa koji je najveci medju datim elementima
	## se nalazi u registru ebx (max_i).
	dec ecx
	mov ebx, ecx
	
	## Ako je u pitanju jednoclani niz, tada nije potrebno traziti
	## najveci, jer je jasno da je to taj jedini element.
	jecxz swap

	## Petlja koja pronalazi najveci medju elementima sa indeksima od 0 do
	## k - 1. Nadjeni maksimalni element se zamenjuje sa elementom na
	## poziciji k - 1.
max_0_to_k_minus_1:

	## U registar edi smestamo vrednost elementa na poziciji max_i.
	mov edi, [edx + 4*ebx]
	
	## U esi upisujemo vrednost pokazivaca koji uporedjujemo sa do sada
	## najvecim (koji se nalazi u edi). 
	mov esi,[edx + 4*ecx - 4]
	
	
	## Petlja u kojoj se leksikografski uporedjuju stringovi.
next_char:

	## Uporedjujemo sledece karaktere.
	cmpsb

	## Ako nisu jednaki, tada izlazimo iz petlje.
	jne last_char

	## Ako jesu, i ako je jedan od njih 0, tada su stringovi jednaki.
	cmp byte ptr [esi-1],0
	je last_char

	## U suprotnom, prelazimo na sledece karaktere.
	jmp next_char
	
last_char:
	## Ako prvi string nije veci od drugog, preskacemo azuriranje.
	jng not_greater

	## U suprotnom, ako je prvi veci od drugog (esi od edi), tada
	## azuriramo ebx (max_i postaje indeks tekuceg elementa).
	mov ebx, ecx
	dec ebx
	
not_greater:
	## Prelazimo na sledeci element.
	loop max_0_to_k_minus_1
	
swap:
	## Skidamo k sa steka.
	pop ecx

	## Umanjujemo registar ecx. Sada sadrzi vrednost k - 1
	dec ecx
	
	## Zamenjujemo elemente na poziciji k - 1 i max_i, samo ako je
	## k - 1 != max_i
	cmp ecx, ebx
	je end_iteration

	## Swap algoritam
	mov esi, [edx + 4*ecx]
	mov edi, [edx + 4*ebx]
	mov [edx + 4*ecx], edi
	mov [edx + 4*ebx], esi

end_iteration:
	## Vracamo ecx na vrednost k.
	inc ecx

	## Sledeca iteracija
	loop main_loop
	
done:	
	## Epilog funkcije
	pop ebx
	pop esi
	pop edi
	leave
	ret
	