#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <string.h>

#define MAX_BUF 256

/* Deklaracija asemblerske funkcije */
void sort_strings(char ** s, int n);



/* Test program */
int main()
{
  char **s; /* Pokazivac na niz pokazivaca na stringove */
  int n; /* Broj stringova */
  char buffer[MAX_BUF]; /* Bafer za ucitavanje */
  int i; /* Brojac u petlji */
  
  /* Ucitavamo n */
  assert(scanf("%d\n", &n) == 1);
  assert(n > 0);
  
  /* Alociramo niz pokazivaca */
  assert((s = malloc(n * sizeof(char *))) != NULL);
  
  /* Ucitavamo n stringova */
  for(i = 0; i < n; i++)
    {
      int length;
      assert(fgets(buffer, MAX_BUF, stdin) != NULL);
      length = strlen(buffer);
      if(length > 0 && buffer[length - 1] == '\n')
	buffer[length - 1] = '\0';
      assert((s[i] = malloc((strlen(buffer) + 1) * sizeof(char))) != NULL);
      strcpy(s[i], buffer);
    }

  /* Pozivamo asemblersku funkciju */
  sort_strings(s, n);

  /* Prikazujemo stringove i dealociramo ih */
  for(i = 0; i < n; i++)
    {
      printf("%s\n", s[i]);
      free(s[i]);
    }
  
  /* Dealociramo niz pokazivaca */
  free(s);
  
  return EXIT_SUCCESS;
}
