.intel_syntax noprefix

.data
two:    .double 2.0

.text
.global arctanh

###########################################################################
##
## Funkcija izracunava vrednost funkcije arctanh(x) za x iz intervala (-1,1)
## koristeci razvoj sum_{i>0}x^(2*i+1)/(2*i+1). Sumiraju se sabirci sve dok
## sabirak koji se dodaje sledeci ne postane po apsolutnoj vrednosti manji
## od eps.
##	
## double arctanh(double x, double eps);
##
## -- double x   -- [ebp+8]  -- broj za koji racunamo vrednost
## -- double eps -- [ebp+16] -- zadata preciznost
##
##########################################################################

arctanh:
	## Prolog funkcije
	enter 0,0

	## Ucitavamo x i eps, dodajemo prvi sabirak (x) na sumu. U svakoj
	## iteraciji cemo na osnovu prethodnog stepena uz x da racunamo
	## sledeci stepen tako sto prethodni mnozimo sa x^2. Takodje, u
	## svakoj iteraciji cemo racunati koeficient kojim delimo stepen
	## tako sto na koeficient iz prethodne iteracije dodamo dva. Zato
	## cemo na steku uvek imati vrednost x^2, 2, prethodni stepen (ps)
	## i prethodni koeficient (pc). Ove vrednosti su incijalno x i 1.
	fld qword ptr [ebp+8]       ## stek: x
	fld qword ptr [ebp+16]      ## stek: x,eps
	fld st(1)		    ## stek: x,eps,x
	fmul st(0), st(2) 	    ## stek: x=S,eps,x^2
	fld qword ptr two	    ## stek: S,eps,x^2,2
	fld st(3)		    ## stek: S,eps,x^2,2,x
	fld1			    ## stek: S,eps,x^2,2,x=ps,1=pc

	## Petlja u kojoj se redom racunaju sabirci i dodaju na sumu dok se
	## ne dobije sabirak koji je manji od eps po apsolutnoj vrednosti.
				    ## stek: S,eps,x^2,2,ps,pc
next:
	## Racunamo sledeci sabirak. Usput azuriramo pc i ps.
	fld st(3)		    ## stek: S,eps,x^2,2,ps,pc,x^2
	fmulp st(2), st(0)	    ## stek: S,eps,x^2,2,ps*x^2,pc
	fld st(2)		    ## stek: S,eps,x^2,2,ps*x^2,pc,2
	faddp st(1), st(0)	    ## stek: S,eps,x^2,2,ps*x^2,pc+2
	fld st(1)		    ## stek: S,eps,x^2,2,ps,pc,ps
	fdiv st(0),st(1)            ## stek: S,eps,x^2,2,ps,pc,t
	fld st(0)		    ## stek: S,eps,x^2,2,ps,pc,t,t
	fabs			    ## stek: S,eps,x^2,2,ps,pc,t,|t|
	fcomip st(0), st(6)	    ## stek: S,eps,x^2,2,ps,pc,t

	## Ako je |t|<eps
	jb finish

	## Dodajemo sabirak na sumu.
	faddp st(6), st(0)          ## stek: S,eps,x^2,2,ps,pc

	## Sledeca iteracija.
	jmp next

finish:
	## Skidamo sa steka nepotrebne vrednosti.
	fcompp			    ## stek: S,eps,x^2,2,ps
	fcompp			    ## stek: S,eps,x^2
	fcompp                      ## stek: S
			
done:	
	## Epilog funkcije
	leave
	ret
	