USE DVDClub;

IF OBJECT_ID('customerMovieLeaseCount', 'TF') IS NOT NULL
BEGIN
DROP FUNCTION customerMovieLeaseCount;
PRINT 'Function customerMovieLeaseCount deleted!';
END
GO

CREATE FUNCTION customerMovieLeaseCount
(
  @GenreName NVARCHAR(50) = NULL
)
RETURNS @ReturnTable TABLE (CustomerID INTEGER, MovieID INTEGER, LeaseCount SMALLINT)
AS
BEGIN

INSERT INTO @ReturnTable
SELECT CustomerID, MovieID, COUNT(*) AS LeaseCount
FROM Lease
WHERE @GenreName IS NULL OR EXISTS (SELECT * FROM MovieGenre
                                    WHERE MovieGenre.MovieID = Lease.MovieID
                                    AND MovieGenre.GenreName = @GenreName)
GROUP BY CustomerID, MovieID;
                                    
RETURN;
END
GO

PRINT 'Function customerMovieLeaseCount created!';