USE DVDClub;
GO

IF OBJECT_ID('addMovie', 'P') IS NOT NULL
BEGIN
DROP PROCEDURE addMovie;
DROP TYPE GenreTableType;
PRINT 'Stored procedure addMovie deleted!';
END
GO

CREATE TYPE GenreTableType AS TABLE (GenreName NVARCHAR(50));
GO

CREATE PROCEDURE addMovie 
(
@MovieName NVARCHAR(200),
@Year  SMALLINT,
@Rating FLOAT,
@Genres GenreTableType READONLY
)
AS

INSERT INTO Movie
VALUES(@MovieName, @Year, @Rating);

DECLARE @MovieID INTEGER = (SELECT MAX(ID) FROM Movie);

INSERT INTO MovieGenre
SELECT @MovieID, GenreName
FROM @Genres;

GO

PRINT 'Stored procedure addMovie created!'