USE DVDClub;
GO

IF OBJECT_ID('mostActiveCustomer', 'P') IS NOT NULL
BEGIN
DROP PROCEDURE mostActiveCustomer;
PRINT 'Stored procedure mostActiveCustomer deleted!';
END
GO

CREATE PROCEDURE mostActiveCustomer 
(
@startDate DATE,
@CustomerID INTEGER OUTPUT,
@LeaseNumber SMALLINT OUTPUT
)
AS

DECLARE @LeaseCount TABLE
(CustomerID INTEGER,
 LeaseNumber SMALLINT);

INSERT INTO @LeaseCount
 SELECT CustomerID, COUNT(*)
 FROM Lease
 WHERE LeaseDate >= @startDate
 GROUP BY CustomerID;

IF (SELECT COUNT(*) 
    FROM @LeaseCount
    WHERE LeaseNumber = (SELECT MAX(LeaseNumber) 
                         FROM @LeaseCount)) > 1 
  RETURN -1;
ELSE
BEGIN
  SELECT TOP(1) @CustomerID =  CustomerID, @LeaseNumber = LeaseNumber
  FROM @LeaseCount
  ORDER BY LeaseNumber DESC;
  RETURN 0;
END

GO

PRINT 'Stored procedure mostActiveCustomer created!'