USE DVDClub;


DECLARE CustomerCurr CURSOR FOR
SELECT ID from Customer;

DECLARE @CustomerID INTEGER;

OPEN CustomerCurr;

FETCH CustomerCurr INTO @CustomerID;

WHILE @@FETCH_STATUS = 0
BEGIN
  
   DECLARE @FirstName NVARCHAR(30);
   DECLARE @LastName NVARCHAR(30);
   
   SELECT @FirstName = FirstName, @LastName = LastName 
   FROM Customer
   WHERE Customer.ID = @CustomerID;
   
   PRINT 'Customer: ' + @FirstName + ' ' + @LastName;
   
   DECLARE MovieCurr CURSOR FOR
   SELECT MovieID, COUNT(*) AS LeaseCount FROM Lease
   WHERE CustomerID = @CustomerID
   GROUP BY MovieID
   ORDER BY LeaseCount DESC;

   DECLARE @MovieID INTEGER;
   DECLARE @LeaseCount SMALLINT;

   OPEN MovieCurr;
   
   FETCH MovieCurr INTO @MovieID, @LeaseCount;

   WHILE @@FETCH_STATUS = 0
   BEGIN
       DECLARE @MovieName NVARCHAR(200);
       SELECT @MovieName = Name FROM Movie
       WHERE Movie.ID = @MovieID;
       PRINT '    Movie: ' + @MovieName + ' leased ' + CAST(@LeaseCount AS NVARCHAR(10)) + ' times';
       
       FETCH MovieCurr INTO @MovieID, @LeaseCount;
   END
   CLOSE MovieCurr;
   DEALLOCATE MovieCurr;
   
   FETCH CustomerCurr INTO @CustomerID;
END

CLOSE CustomerCurr;
DEALLOCATE CustomerCurr;