USE DVDClub;

DECLARE @LeasesPerDay TABLE 
(
   EmployeeID INTEGER,
   LeaseDate  DATE,
   LeaseCount INTEGER
);

INSERT INTO @LeasesPerDay
SELECT EmployeeID, LeaseDate, COUNT(*)
FROM Lease
GROUP BY EmployeeID, LeaseDate;

DECLARE @AvgLeasesPerDay TABLE
(
   EmployeeID INTEGER,
   AvgLeases DOUBLE PRECISION
);

INSERT INTO @AvgLeasesPerDay
SELECT EmployeeID, AVG(LeaseCount *1.0)
FROM @LeasesPerDay
GROUP BY EmployeeID;

SELECT Employee.*, ALD.AvgLeases
FROM Employee JOIN @AvgLeasesPerDay AS ALD ON 
     Employee.ID = ALD.EmployeeID
ORDER BY ALD.AvgLeases DESC;