.intel_syntax noprefix

.data
four:	.int	4	# Broj 4.
two:	.int	2	# Broj 2.
		
.text
.global quadric

	## Funkcija quadric() odredjuje realne korijene kvadratne
	## jednacine a*x^2+b*x+c=0. Argumenti funkcije su:
	##   [ebp+8] - koeficijent jednacine uz x^2
	##   [ebp+16] - koeficijent jednacine uz x^1
	##   [ebp+24] - koeficijent jednacine uz x^0
	##   [ebp+32] - adresa lokacije na koju treba smjestiti prvi korijen
	##   [ebp+36] - adresa lokacije na koju treba smjestiti drugi korijen
	## Funkcija vraca broj pronadjenih realnih korijena. Ukoliko
	## jednacina nema realnih korijena, lokacije na koje pokazuju
	## cetvrti i peti argument ostaju neizmijenjene. Ukoliko
	## jednacina ima jedan realni korijen, njegova vrijednost biva
	## upisana u lokaciju na koju pokazuje cetvrti argument.
quadric:
	## Prolog funkcije.
        enter   0, 0
	push	edi

	## Izracunava se diskriminanta jednacine b^2-4*a*c
	fld	qword ptr [ebp+16]	# Stek:	b
        fld     st                      # Stek:	b, b
	fmulp           		# Stek:	b^2
	fild	dword ptr four		# Stek:	b^2, 4
        fld	qword ptr [ebp+8]	# Stek:	b^2, 4, a
	fmulp                   	# Stek:	b^2, 4*a
	fld	qword ptr [ebp+24]	# Stek:	b^2, 4*a, c
	fmulp                           # Stek:	b^2, 4*a*c
	fsubp				# Stek:	b^2-4*a*c

	## Ispituje se da li je diskriminanta jednaka 0 i ako jeste odmah se
	## izlazi iz funkcije.
	fldz				# Stek:	b^2-4*a*c, 0
	fcomip  st, st(1)               # Stek:	b^2-4*a*c
	je single_root
	jb multiple_roots

no_roots:
	## Brise se diskriminanta sa steka.
	ffree	st
	fincstp
	
	## Postavlja se rezultat na 0 i izlazi se iz funkcije.
	xor	eax, eax
	jmp done

single_root:
	## Brise se diskriminanta sa steka.
	ffree	st
	fincstp
	
	## Izracunava se korijen jednacine -b/(2*a).
	fld	qword ptr [ebp+16]	# Stek:	b
	fchs				# Stek:	-b
	fld	qword ptr [ebp+8]	# Stek:	-b, a
	fimul	dword ptr two		# Stek:	-b, 2*a
	fdivp				# Stek:	-b/(2*a)

	## Smjesta se korijen na odgovarajucu memorijsku
	## lokaciju. Registar edi ce drzati adresu te lokacije.
	mov	edi, [ebp+32]
	fstp	qword ptr [edi]

	## Postavlja se rezultat na 1 i izlazi se iz funkcije.
	mov	eax, 1
	jmp done

multiple_roots:
        ## Izracunavaju se kvadratni korijen diskriminante i vrijednost
	## imenioca u izrazu za korijene jednacine.
	fsqrt                           # Stek:	sqrt(b^2-4*a*c)=S
        fld	qword ptr [ebp+8]       # Stek: S, a
        fimul	dword ptr two		# Stek:	S, 2*a
        fxch                            # Stek:	2*a, S
	
	## Izracunava se prvi korijen jednacine.
	fld	qword ptr [ebp+16]	# Stek:	2*a, S, b
	fchs				# Stek:	2*a, S, -b
	fadd	st, st(1)		# Stek:	2*a, S, -b+S
	fdiv    st, st(2)		# Stek:	2*a, S, (-b+S)/(2*a)

	## Smjesta se prvi korijen na odgovarajucu memorijsku lokaciju.
	## Registar edi ce drzati adresu te lokacije.
	mov	edi, [ebp+32]
	fstp	qword ptr [edi]         # Stek:	2*a, S

	## Izracunava se drugi korijen jednacine.
	fld	qword ptr [ebp+16]	# Stek:	2*a, S, b
	faddp                           # Stek:	2*a, b+S
	fchs				# Stek:	2*a, -b-S
	fdivrp				# Stek:	(-b-S)/(2*a)

	## Smjesta se drugi korijen na odgovarajucu memorijsku lokaciju. 
	## Registar edi ce drzati adresu te lokacije.
	mov	edi, [ebp+36]
	fstp	qword ptr [edi]
	
	## Postavlja se rezultat na 2 i izlazi se iz funkcije.
	mov	eax, 2

done:
	## Epilog funkcije.
	pop	edi
	leave
	ret	

