.intel_syntax noprefix

.data

.text

.global lnxplus1

	
###########################################################################
##
##  Funkcija:
##	
##  double lnxplus1(double x, double eps); 
##
##  racuna vrednost ln(x+1) kao parcijalnu sumu stepenog reda, sa 
##  preciznoscu eps. 
##  
##  double x -- [ebp+8] -- broj ciji ln(x+1) racunamo
##  double eps -- [ebp+16] -- preciznost
###########################################################################
lnxplus1:

	## Prolog funkcije
	enter 0,0


	
	## Pripremamo fpu-stek, na koji smestamo 0 (kao inicijalnu vrednost
	## sume), argumente funkcije (x i eps), a zatim i broj 1 (kao x^0,
	## ovaj registar cemo u svakoj iteraciji mnoziti sa x, kako bismo
	## dobili x^n). 
	fldz				## stek: 0
	fld qword ptr [ebp+8]		## stek: 0,x
	fld qword ptr [ebp+16]		## stek: 0,x,eps
	fld1				## stek: 0,x,eps,1

	## Registar ecx ce cuvati celobrojnu vrednost n. Na pocetku svake
	## iteracije cemo ga uvecavati za 1 (prvi sabirak je za n=1).
	xor ecx,ecx

	## Glavna petlja. U ovoj petlji racunamo sledeci sabirak, proveravamo
	## da li je veci po apsolutnoj vrednosti od eps, i ako jeste, dodajemo
	## ga na sumu. U komentarima nakon svake iteracije S je oznaka za sumu
	## prvih n sabiraka, a S' je oznaka za sumu prvih n-1 sabiraka. Kada se
	## n uveca za jedan, tada S postaje S'.
	
					## stek: S,x,eps,x^n
main_loop:

	## Uvecavamo n za jedan.
	inc ecx				## stek: S',x,eps,x^(n-1)

	## Racunamo x^n
	fmul st(0), st(2)		## stek: S',x,eps,x^n
	fld st(0)                       ## stek: S',x,eps,x^n,x^n

	## Racunamo x^n/n.
	push ecx
	fidiv dword ptr [esp]		## stek: S',x,eps,x^n,x^n/n
	add esp,4

	## Ispitujemo da li je |x^n/n| < eps 
	fld st(0)			## stek: S',x,eps,x^n,x^n/n,x^n/n
	fabs				## stek: S',x,eps,x^n,x^n/n,|x^n/n|
	fcomip st, st(3)		## stek: S',x,eps,x^n,x^n/n

	## Ako jeste, zavrsavamo petlju.
	jb done

	## Proveravamo da li je n parno ili neparno.
	test ecx,1
	jnz add 

	## Za parno n, moramo da dodamo minus.
	fchs				## stek: S',x,eps,x^n,-x^n/n

add:
	## Dodajemo sabirak na sumu, i prelazimo na sledecu iteraciju.
	faddp st(4), st(0)		## stek: S,x,eps,x^n
	jmp main_loop

					## stek: S,x,eps,x^n,x^n/n
done:
	## Skidamo sa fpu-steka sve vrednosti osim sume S.
	fcompp				## stek: S,x,eps
	fcompp				## stek: S

	## Epilog funkcije
	leave
	ret
	