.intel_syntax noprefix

.data
two:    .double 2.0

.text
.global zeta

###########################################################################
##
## Funkcija izracunava vrednost Rimanove zeta funkcije za x > 1
## koristeci razvoj sum_{i > 0} 1/n^x. Sumiraju se sabirci sve dok
## sabirak koji se dodaje sledeci ne postane po apsolutnoj vrednosti manji
## od eps.
##	
## double zeta(double x, double eps);
##
## -- double x   -- [ebp+8]  -- broj za koji racunamo vrednost
## -- double eps -- [ebp+16] -- zadata preciznost
##
##########################################################################

zeta:
	## Prolog funkcije
	enter 0,0

	fldz		 		# stek: 0 = S
	fld qword ptr [ebp + 8]		# stek: S,x
	fld qword ptr [ebp + 16]	# stek: S,x,eps

	## ecx ce sadrzati n
	mov ecx, 1
	
next:
	## Postavljamo n na stek
	push ecx
	fild dword ptr [esp]   # stek: S,x,eps,n
	add esp, 4
	
	fld st(2)	       # stek: S,x,eps,n,x
	fxch		       # stek: S,x,eps,x,n
	fyl2x		       # stek: S,x,eps,x*log_2(n) = L
	
	fld	st		# Stek:	S,x,eps,L,L
	frndint			# Stek:	S,x,eps,L,int(L)
	fsub	st(1), st	# Stek:	S,x,eps,L-int(L)=frac(L), int(L)
	fxch			# Stek:	S,x,eps,int(L),frac(L)
	f2xm1			# Stek:	S,x,eps,int(L),2^frac(L)-1
	fld1			# Stek:	S,x,eps,int(L),2^frac(L)-1,1
	faddp			# Stek:	S,x,eps,int(L),2^frac(L)
	fscale			# Stek:	S,x,eps,int(L),2^int(L)*2^frac(L)=2^(int(L)+frac(L))=2^L
	fxch			# Stek:	S,x,eps,2^L,int(L)
	ffree	st		# Stek:	S,x,eps,2^L,invalidna vrednost
	fincstp			# Stek:	S,x,eps,2^L=2^log_2(n^x)=n^x

	fld1			# Stek: S,x,eps,n^x,1
	fxch			# Stek: S,x,eps,1,n^x
	fdivp			# Stek: S,x,eps,1/n^x

	## Uporedjujemo apsolutnu vrednost sabirka sa eps
	fld st(0)		# Stek: S,x,eps,1/n^x,1/n^x
	fabs			# Stek: S,x,eps,1/n^x,|1/n^x|
	fcomip st(0), st(2)	# Stek: S,x,eps,1/n^x

	## Ako je |1/n^x|<eps
	jb finish

	## Dodajemo sabirak na sumu
	faddp st(3),st(0)	# Stek: S,x,eps

	## Sledeca iteracija.
	inc ecx
	jmp next

finish:
	## Skidamo sa steka nepotrebne vrednosti.
	fcompp			    ## stek: S,x
	fcomp                       ## stek: S
			
done:	
	## Epilog funkcije
	leave
	ret
	