`include "rsl.v"

module rsl_test;
   reg s, r, e;
   wire q, qp;
   
   rsl _rsl(s, r, e, q, qp);
   
   initial
     begin
	$monitor($time, ": e: %b, s: %b, r: %b, q: %b, qp: %b", e, s, r, q, qp);

	// Kada je e == 0, kolo ne reaguje na promene r i s ulaza
	e = 0; 
        s = 0; r = 0; 
	#10 s = 1;
	#10 s = 0;
	#10 r = 1;
	#10 r = 0;

	// Kada je e == 1, tada kolo reaguje na promene ulaza r i s
	#10 e = 1;	
	#10 s = 1;
	#10 s = 0;
	#10 r = 1;
	#10 r = 0;

	// Nedozvoljena kombinacija na ulazu (Icarus verilog daje q = 0, qp = 0
	// mada se u realnom slucaju moglo desiti da oba budu 1, zavisno od toga
	// koje od dva nor kola prvo propagira vrednost)
	#10  s = 1; r = 1;
	#10 ;
	
     end
   

endmodule
