module tff(t, e, q, qp);
   input t, e;
   output reg q, qp;

   /* Ovaj proces inicijalizuje vrednosti q i qp */
   initial
     begin
	q = 0;
	qp = 1;	
     end
   
   // Varijanta sa klasicnim blokirajucim dodelama ne radi
   // Moraju se koristiti neblokirajuce naredbe dodele
/*   always @(posedge e)
     if(t)
       begin
	  q = qp;
	  qp = q;	     
       end
*/

   /* Neblokirajuca naredba proceduralne dodele (<=) se izvrsava u dve 
    faze: najpre se izracunaju sve desne strane, a onda se na kraju 
    vremenske jedinice vrsi upisivanje u promenljive na levoj strani.
    Zbog toga ce u donjem primeru u q biti upisana stara vrednost qp a
    u qp stara vrednost od q (pre upisa nove vrednosti). Neblokirajuce
    naredbe dodele se uglavnom koriste kod sekvencijalnih kola  */
   always @(posedge e)
     if(t)
       begin
	  q <= qp;
	  qp <= q;	     
       end

endmodule // tff
