.intel_syntax noprefix

.data
zero:   .float  0               # Broj 0.
        
.text
.global shortest_distance

	## Funkcija shortest_distance() izracunava najkrace rastojanje
        ## izmedju dvije prave, pri cemu je svaka prava odredjena sa po
	## dvije tacke.  Argumenti funkcije su:
        ##   [ebp+8], [ebp+12] - adrese sa koordinatama tacaka koje
	##                       odredjuju prvu pravu
        ##   [ebp+16], [ebp+20] - adrese sa koordinatama tacaka koje
	##                        odredjuju drugu pravu
        ##   [ebp+24] - adresa na koju treba smjestiti izracunato
	##              rastojanje
        ## Pretpostavka je da date prave nisu paralelne. Funkcija se u
	## potpunosti podvrgava C konvencijama pozivanja.
shortest_distance:
        ## Prolog funkcije.
	enter   16, 0
        push    esi
        push    edi

        ## Provjerava se da li procesor podrzava SSE instrukcije.
        mov     eax, 1
        cpuid
        test    edx, 0x2000000
        jz done

        ## Cuva se sadrzaj SSE registara i registara koprocesora.
        mov     edx, esp
        and     esp, 0xfffffff0
        sub     esp, 512
        fxsave  [esp]

        ## Postavlja se direction fleg na odgovarajucu vrijednost.
        cld

        ## Preko pomocnog niza, u registar xmm0 se upisuju koordinate
        ## prve tacke prve prave (u oznaci tacka S0).
        mov     ecx, 3
        mov     esi, [ebp+8]
        lea     edi, [ebp-16]
        rep movsd
        movups  xmm0, [ebp-16]

        ## Na isti nacin, u registre xmm1, xmm2 i xmm3 se upisuju
        ## koordinate druge tacke prve prave odn. prve i druge tacke
	## druge prave (u oznaci tacke S1, T0 i T1).
        mov     ecx, 3
        mov     esi, [ebp+12]
        lea     edi, [ebp-16]
        rep movsd
        movups  xmm1, [ebp-16]
        mov     ecx, 3
        mov     esi, [ebp+16]
        lea     edi, [ebp-16]
        rep movsd
        movups  xmm2, [ebp-16]
        mov     ecx, 3
        mov     esi, [ebp+20]
        lea     edi, [ebp-16]
        rep movsd
        movups  xmm3, [ebp-16]

        ## U registrima xmm1 i xmm2 se formiraju vektori pravca pravih
        ## (u oznaci vektori DS i DT), a u registru xmm0 vektor od tacke
	## S0 do tacke T0 (u oznaci vektor ST).
        subps   xmm1, xmm0
        subps   xmm3, xmm2
        subps   xmm2, xmm0
        movaps  xmm0, xmm2
        movaps  xmm2, xmm3

        ## U registru xmm1 se izracunava vektorski proizvod vektora DS i
        ## DT (u oznaci vektor V, ovaj vektor je vektor pravca najkraceg
	## rastojanja izmedju pravih).
        movaps  xmm3, xmm1
        movaps  xmm4, xmm2
        shufps  xmm1, xmm1, 0xc9
        shufps  xmm2, xmm2, 0xd2
        shufps  xmm3, xmm3, 0xd2
        shufps  xmm4, xmm4, 0xc9
        mulps   xmm1, xmm2
        mulps   xmm3, xmm4
        subps   xmm1, xmm3

        ## Normalizuje se vektor V, pri cemu se norma izracunava u
	## registru xmm2.
        movaps  xmm2, xmm1
        mulps   xmm2, xmm2
        movaps  xmm3, xmm2
        shufps  xmm3, xmm3, 0x01
        movaps  xmm4, xmm2
        shufps  xmm4, xmm4, 0x02
        addss   xmm2, xmm3
        addss   xmm2, xmm4
        rsqrtss xmm2, xmm2
        shufps  xmm2, xmm2, 0x00
        mulps   xmm1, xmm2

        ## Trazeno rastojanje jednako je apsolutnoj vrijednosti
	## skalarnog proizvoda vektora ST i V.
        mulps   xmm0, xmm1
        movaps  xmm1, xmm0
        shufps  xmm1, xmm1, 0x01
        movaps  xmm2, xmm0
        shufps  xmm2, xmm2, 0x02
        addss   xmm0, xmm1
        addss   xmm0, xmm2
        movss   xmm1, zero
        comiss  xmm0, xmm1
        jae store_result
        subss   xmm1, xmm0
        movss   xmm0, xmm1
store_result:                
        mov     edi, [ebp+24]
        movss   [edi], xmm0

        ## Vraca se prethodni sadrzaj u registre koprocesora i SSE
        ## registre.
        fxrstor [esp]
        mov     esp, edx

done:        
	## Epilog funkcije.
        pop     edi
        pop     esi
	leave
        ret
