#include <assert.h>
#include <stdio.h>

/* Deskriptivna imena za indekse koordinata tacaka. */
#define X 0
#define Y 1
#define Z 2

/* Deklaracija funkcije shortest_distance(). */
extern void     shortest_distance(float *S0, float *S1, float *T0,
				  float *T1, float *d);

int
main()
{
	float           S0[3],
	                S1[3];	/* Koordinate tacaka na prvoj pravoj. */
	float           T0[3],
	                T1[3];	/* Koordinate tacaka na drugoj pravoj. */
	float           d;	/* Najkrace rastojanje medju pravima. */

	/* Ucitavaju se koordinate tacaka koje odredjuju prave i ispituje
	 * se njihova validnost. */
	scanf("%f%f%f%f%f%f", &S0[X], &S0[Y], &S0[Z], &S1[X], &S1[Y],
	      &S1[Z]);
	assert(S0[X] != S1[X] || S0[Y] != S1[Y] || S0[Z] != S1[Z]);
	scanf("%f%f%f%f%f%f", &T0[X], &T0[Y], &T0[Z], &T1[X], &T1[Y],
	      &T1[Z]);
	assert(T0[X] != T1[X] || T0[Y] != T1[Y] || T0[Z] != T1[Z]);

	/* Provjerava se da prave nisu paralelne. */
	assert((S1[Y] - S0[Y]) * (T1[Z] - T0[Z]) !=
	       (S1[Z] - S0[Z]) * (T1[Y] - T0[Y])
	       || (S1[Z] - S0[Z]) * (T1[X] - T0[X]) !=
	       (S1[X] - S0[X]) * (T1[Z] - T0[Z])
	       || (S1[X] - S0[X]) * (T1[Y] - T0[Y]) !=
	       (S1[Y] - S0[Y]) * (T1[X] - T0[X]));

	/* Izracunava se i stampa najkrace rastojanje medju datim pravima. 
	 */
	shortest_distance(S0, S1, T0, T1, &d);
	printf("%g\n", d);

	return 0;
}
