.intel_syntax noprefix

.data
mask:   .int    0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff # Maska za izracunavanje apsolutnih vrijednosti brojeva u nekom SSE registru.

.text
.global norms

	## Funkcija norms() izracunava uniformnu i euklidsku normu date
	## matrice. Argumenti funkcije su:
        ##   [ebp+8], [ebp+12] - dimenzije matrice
        ##   [ebp+16] - adresa niza sa adresama na koje su smjesteni
	##              elementi pojedinacnih redova date matrice
        ##   [ebp+20], [ebp+24] - adrese lokacija na koje treba upisati
	##                        izracunate vrijednosti uniformne,
	##                         odn. euklidske, norme date matrice
        ## Pretpostavka je da su dimenzije matrice pozitivni brojevi.
	## Funkcija se u potpunosti podvrgava C konvencijama pozivanja.
norms:
        ## Prolog funkcije.
        enter   0, 0
        push    ebx
        push    esi
        push    edi

        ## Provjerava se da li procesor podrzava SSE instrukcije.
        mov     eax, 1
        cpuid
        test    edx, 0x2000000
        jz done

        ## Cuva se sadrzaj SSE registara i registara koprocesora.
        mov     edx, esp
        and     esp, 0xfffffff0
        sub     esp, 512
        fxsave  [esp]

        ## Na poziciji najmanje tezine u registru xmm0 bice cuvana
        ## tekuca vrijednost uniformne norme, dok ce registar xmm1
        ## sadrzati parcijalne sume za racunanje euklidske norme.  U
	## registar xmm7 se ucitava bitska maska koja sluzi za
        ## izracunavanje apsolutne vrijednosti brojeva u nekom registru.
        xorps   xmm0, xmm0
        xorps   xmm1, xmm1
        movups  xmm7, mask

        ## Registar ecx ce sluziti kao brojac u spoljasnjoj i
        ## unutrasnjoj petlji izracunavanja koje slijedi, i
        ## inicijalizuje se na broj redova matrice.  Broj kolona matrice
        ## ce biti cuvan u registru eax.  Registar ebx ce cuvati adresu
	## na kojoj se nalazi adresa prvog elementa tekuceg reda
	## matrice.
        mov     ecx, [ebp+8]
        mov     eax, [ebp+12]
        mov     ebx, [ebp+16]

next_row:
        ## Registar ecx se, kao brojac za unutrasnju petlju
        ## inicijalizuje na broj kolona matrice.  Registar esi ce
        ## sadrzati adresu na kojoj se nalazi tekuci element tekuceg
        ## reda matrice.  Registar xmm2 ce sluziti za akumuliranje
        ## parcijalnih suma pri racunanju sume apsolutnih vrijednosti
	## elemenata tekuceg reda matrice.
        push    ecx
        mov     ecx, eax
        mov     esi, [ebx]
        xorps   xmm2, xmm2

next_four:
        ## Provjerava se da li ima 4 ili vise preostalih elemenata u
        ## tekucem redu matrice i, ako to nije slucaj, prelazi se na
	## procesiranje pojedinacnih preostalih elemenata tekuceg reda
	## matrice.
        cmp     ecx, 4
        jb next_one

        ## Ucitavaju se naredna 4 elementa tekuceg reda matrice, i
        ## azuriraju se parcijalne sume za racunanje sume apsolutnih
        ## vrijednosti elemenata tekuceg reda, odn. za racunanje
	## euklidske norme matrice.
        movups  xmm3, [esi]
        andps   xmm3, xmm7
        addps   xmm2, xmm3
        mulps   xmm3, xmm3
        addps   xmm1, xmm3

        ## Prelazi se na narednu iteraciju.
        add     esi, 16
        sub     ecx, 4
        jmp next_four
        
next_one:
        ## Provjerava se da li ima preostalih elemenata u tekucem redu
        ## matrice i, ako to nije slucaj, prelazi se na eventualno
	## azuriranje uniformne norme matrice.
        jecxz update_uniform_norm

        ## Ucitava se naredni elementa tekuceg reda matrice, i azuriraju
        ## se parcijalne sume za racunanje sume apsolutnih vrijednosti
        ## elemenata tekuceg reda, odn. za racunanje euklidske norme
	## matrice.
        movss   xmm3, [esi]
        andps   xmm3, xmm7
        addss   xmm2, xmm3
        mulss   xmm3, xmm3
        addss   xmm1, xmm3

        ## Prelazi se na narednu iteraciju.
        add     esi, 4
        dec     ecx
        jmp next_one
        
update_uniform_norm:
        ## Izracunava se suma apsolutnih vrijednosti elemenata tekuceg
        ## reda matrice i prema potrebi se azurira vrijednost uniformne
	## norme matrice.
        movhlps xmm3, xmm2
        addps   xmm2, xmm3
        movaps  xmm3, xmm2
        shufps  xmm3, xmm3, 0b01010101
        addss   xmm2, xmm3
        comiss  xmm0, xmm2
        jae continue
        movaps  xmm0, xmm2
                  
continue:
        ## Prelazi se na procesiranje narednog reda matrice.
        add     ebx, 4
        pop     ecx
        loop next_row

        ## Upisuje se vrijednost uniformne norme matrice u za to
	## predvidjenu lokaciju u memoriji.
        mov     edi, [ebp+20]
        movss   [edi], xmm0

        ## Izracunava se, i upisuje u za to predvidjenu lokaciju u
	## memoriji, vrijednost euklidske norme matrice.
        movhlps xmm2, xmm1
        addps   xmm1, xmm2
        movaps  xmm2, xmm1
        shufps  xmm2, xmm2, 0b01010101
        addss   xmm1, xmm2
        sqrtss  xmm1, xmm1
        mov     edi, [ebp+24]
        movss   [edi], xmm1
        
        ## Vraca se prethodni sadrzaj u registre koprocesora i SSE
        ## registre.
        fxrstor [esp]
        mov     esp, edx

done:
	## Epilog funkcije.
        pop     edi
        pop     esi
        pop     ebx
	leave
        ret
