#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

/* Deklaracija funkcije norms(). */
extern void     norms(int m, int n, float **A, float *u, float *e);

int
main(void)
{
	int             m,
	                n;	/* Dimenzije matrice. */
	float         **A;	/* Niz sa adresama na kojima su smjesteni
				 * redovi matrice. */
	float           u,
	                e;	/* Vrijednosti uniformne i euklidske norme 
				 * matrice. */
	int             i,
	                j;	/* Brojaci u petljama. */

	/* Ucitavaju se dimenzije matrice. */
	scanf("%d%d", &m, &n);
	assert(m > 0 && n > 0);

	/* Alocira se potrebna memorija, i ucitavaju se elementi matrice. */
	A = malloc(m * sizeof(float *));
	assert(A != NULL);
	for (i = 0; i < m; ++i) {
		A[i] = malloc(n * sizeof(float));
		for (j = 0; j < n; ++j)
			scanf("%f", &A[i][j]);
	}

	/* Izracunavaju se, i stampaju na standardni izlaz, vrijednosti
	 * uniformne i Euklidske norme date matrice. */
	norms(m, n, A, &u, &e);
	printf("%g %g\n", u, e);

	/* Oslobadja se alocirana memorija. */
	for (i = 0; i < m; ++i)
		free(A[i]);
	free(A);

	return 0;
}
