#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

extern void     fir(int m, float *c, int n, float *x, float *y);

/*
 * Program sluzi za testiranje funkcije fir(). Program ucitava niz
 * koeficijenata i ulazni niz sa standardnog ulaza, standardnog ulaza, a
 * zatim poziva funkciju fir() da izracuna izlazni niz, koji se potom stampa
 * na standardni izlaz.
 */
int
main()
{
	int             m;	/* Broj koeficijenata. */
	float          *c;	/* Niz koeficijanata. */
	int             n;	/* Broj elemenata ulaznog niza. */
	float          *x;	/* Ulazni niz. */
	float          *y;	/* Izlazni niz. */
	int             i;	/* Brojac u petljama. */

	/*
	 * Ucitava se broj koeficijenata, a potom se alocira memorija i
	 * ucitava se niz koeficijenata.
	 */
	scanf("%d", &m);
	assert(m > 0);
	c = (float *)malloc(m * sizeof(float));
	assert(c != NULL);
	for (i = 0; i < m; i++)
		scanf("%f", &c[i]);

	/*
	 * Ucitava se broj elemenata ulaznog niza, a potom se alocira
	 * memorija i ucitava se ulazni niz.
	 */
	scanf("%d", &n);
	assert(n >= m);
	x = (float *)malloc(n * sizeof(float));
	assert(x != NULL);
	for (i = 0; i < n; i++)
		scanf("%f", &x[i]);

	/*
	 * Alocira se memorija za izlazni niz i prvih m-1 elemenata niza
	 * se postavlja na 0.
	 */
	y = (float *)malloc(n * sizeof(float));
	assert(y != NULL);
	for (i = 0; i < m; i++)
		y[i] = 0;

	/* Izracunava se izlazni niz. */
	fir(m, c, n, x, y + m - 1);

	/*
	 * Oslobadja se memorija koriscena za niz koeficijenata i ulazni niz.
	 */
	free(c);
	free(x);

	/* Stampa se izlazni niz. */
	printf("%d\n", n);
	for (i = 0; i < n; i++)
		printf("%g\n", y[i]);

	/* Oslobadja se memorija koriscena za izlazni niz. */
	free(y);

	return 0;
}
