#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

/* Deklaracija funkcije dot_product(). */
void dot_product(float *x, float *y, int n, float *r);

int
main(void)
{
  int n;              /* Dimenzija vektora x i y */
  float *x, *y;       /* Pokazivaci na vektore x i y */
  float r;            /* Rezultat */
  int i;              /* Brojac u petljama */  

  /* Ucitavamo dimenziju */
  assert(scanf("%d", &n) == 1);
  
  /* Alociramo prostor */
  assert((x = malloc(sizeof(float)*n)) != NULL);
  assert((y = malloc(sizeof(float)*n)) != NULL);
  
  /* Ucitavamo elemente vektora */
  for(i = 0;  i < n; i++)
    assert(scanf("%f", &x[i]) == 1);
  for(i = 0;  i < n; i++)
    assert(scanf("%f", &y[i]) == 1);

  /* Pozivamo funkciju */
  dot_product(x, y, n, &r);

  /* Prikazujemo rezultat */
  printf("%f\n", r);

  /* Oslobadjamo prostor */
  free(x);
  free(y);
  
  return 0;
}
