.intel_syntax noprefix

.data

.text
.global dot_product

############################################################################
##
## Funkcija:
##
## void dot_product(float *x, float *y, int n, float *r);
##
## izracunava skalarni proizvod vektora x i y dimenzije n, i rezultat smesta
## na adresu r. Argumenti funkcije:
##
## -- float * x -- [ebp+8] -- adresa prvog vektora
## -- float * y -- [ebp+12] -- adresa drugog vektora
## -- int n -- [ebp+16] -- dimenzija vektora
## -- float * r -- [ebp+20] -- adresa na koju se smesta rezultat.
##
############################################################################
dot_product:
        ## Prolog funkcije.
        enter   0, 0
        push    ebx
        push    esi
        push    edi

        ## Proverava se da li procesor podrzava SSE instrukcije.
        mov     eax, 1
        cpuid
        test    edx, 0x2000000
        jz not_supported

        ## Cuva se sadrzaj SSE registara i registara koprocesora.
        mov     edx, esp
        and     esp, 0xfffffff0
        sub     esp, 512
        fxsave  [esp]

	## U ecx smestamo dimenziju n. U esi smestamo adresu prvog, a u edi
	## adresu drugog vektora.
	mov ecx, [ebp+16]
	mov esi, [ebp+8]
	mov edi, [ebp+12]

	## Registar xmm0 cemo koristiti za parcijalne sume.
	xorps xmm0, xmm0
next_four:
        ## Dokle god ima bar jos cetiri elemenata...
        cmp     ecx, 4
        jb next_one

	## ...ucitavamo sledeca cetiri elemenata iz oba vektora, mnozimo ih
	## i dodajemo na parcijalne sume.
        movups  xmm1, [esi]
        movups  xmm2, [edi]
	mulps xmm1, xmm2
	addps xmm0, xmm1
	
        
        ## Prelazi se na narednu iteraciju.
        add     esi, 16
	add     edi, 16  
        sub     ecx, 4
        jmp next_four
        
next_one:
	## Dokle god ima jos elemenata...
        jecxz finish

	## ...ucitavamo sledece elemente iz oba vektora, mnozimo ih i dodajemo
	## na najnizu parcijalnu sumu.
	movss  xmm1, [esi]
        movss  xmm2, [edi]
	mulss xmm1, xmm2
	addss xmm0, xmm1
	
        
        ## Prelazi se na narednu iteraciju.
        add     esi, 4
	add     edi, 4
        dec     ecx
        jmp next_one
        
finish:	
        ## Sabiramo 4 parcijalne sume i dobijamo konacnu sumu u najnizem
	## podatku registra xmm0. 
        movhlps xmm1, xmm0
        addps   xmm0, xmm1
        movaps  xmm1, xmm0
        shufps  xmm1, xmm1, 0b01010101
        addss   xmm0, xmm1
        
        ## Upisujemo podatak na za to predvidjenu lokaciju u memoriji.          
        mov     edi, [ebp+20]
        movss   [edi], xmm0
 
        ## Vraca se prethodni sadrzaj u registre koprocesora i SSE
        ## registre.
        fxrstor [esp]
        mov     esp, edx

done:
	## Epilog funkcije.
        pop     edi
        pop     esi
        pop     ebx
	leave
        ret

not_supported:
	## Ako SSE instrukcije nisu podrzane, prekidamo program exit(1)
        ## pozivom.
        mov eax, 1
        mov ebx, 1
        int 0x80
