.intel_syntax noprefix

.data
table:
        ## Tabela koja sadrzi vrednosti -1 za sve karaktere osim
        ## samoglasnika, a za samoglasnike vrednosti od 0 do 4 kao
        ## njihove indekse prema abecednom redosledu.
        .fill   65, 1, -1
        .byte   0
        .fill   3, 1, -1
        .byte   1
        .fill   3, 1, -1
        .byte   2
        .fill   5, 1, -1
        .byte   3
        .fill   5, 1, -1
        .byte   4
        .fill   11, 1, -1
        .byte   0
        .fill   3, 1, -1
        .byte   1
        .fill   3, 1, -1
        .byte   2
        .fill   5, 1, -1
        .byte   3
        .fill   5, 1, -1
        .byte   4
        .fill   138, 1, -1
        
.text
.global vowels

#######################################################################
## Funkcija:
##
## int vowels(char * string)
##
## odreduje da li dati string sadrzi sve samoglasnike, i to prema
## neopadajucem abecednom redosledu. Argumenti funkcije su:
##
## -- char * string -- [ebp+8] - string koji se ispituje
##
## Funkcija vraca 1 ako dati string zadovoljava dati kriterijum,
## odn. 0 u suprotnom.  
######################################################################
vowels:
        ## Prolog funkcije.
        enter   0, 0
        push    esi

        ## Citanje stringa ce se odvijati od pocetka prema kraju
        ## stringa, pa se direction fleg postavlja na odgovarajucu
        ## vrednost.  Registar esi ce sadrzati adresu tekuceg
        ## karaktera stringa. Registar cl ce sadrzati indeks poslednjeg
        ## uocenog samoglasnika u stringu; ovaj registar se
	## inicijalizuje na -1 kako bi korisceni algoritam pravilno
	## startovao.  U registar ebx se ucitava adresa date tabele.
        cld        
        mov     esi, [ebp+8]
        mov     cl, -1
        lea     ebx, table

next_char:
        ## Ucitava se naredni karakter i proverava se da li se doslo do
	## kraja stringa.
        lodsb
        cmp al, 0
        je final_check

        ## Vrsi se mapiranje karaktera u odgovarajuci indeks pomocu date
        ## tabele.  Ako karakter nije samoglasnik, prelazi se na naredni
	## karakter.
        xlatb
        cmp     al, -1
        je next_char

        ## Ako je u pitanju isti samoglasnik kao samoglasnik koji je
	## poslednji uocen, prelazi se na naredni karakter.
        cmp     al, cl
        je next_char

        ## Ako je u pitanju samoglasnik koji sledi poslednji uoceni
        ## samoglasnik po abecednom redosledu, azurira se indeks
        ## poslednjeg uocenog samoglasnika i prelazi se na naredni
        ## karakter; u suprotnom, moze se odmah konstatovati da dati
	## string ne ispunjava trazene uslove.
        dec     al
        cmp     al, cl
        jne no
        inc     cl
        jmp next_char

final_check:
        ## Proverava se da li je 'u' samoglasnik koji je poslednji
        ## uocen u stringu i, ako jeste, vraca se pozitivan rezultat iz
	## funkcije,...
        cmp     cl, 4
        jne no
        mov     eax, 1
        jmp done

no:
        ## ...a u suprotnom se vraca negativan rezultat iz funkcije.
        xor     eax, eax
        
done:                
        ## Epilog funkcije.
        pop     esi
        leave
        ret
