.text
.align 2


.global count_primes

@ Funkcija:
@
@ int count_primes(int n);
@
@ racuna koliko ima prostih brojeva k <= n. Argument funkcije je:
@
@ r0 -- int n
@	
count_primes:
	@ Prolog funkcije
	stmfd sp!, {fp, lr}
	mov fp, sp

	@ Cuvamo na steku vrednosti registara koje cemo koristiti.
	stmfd sp!, {r4-r6}

	@ U r4 smestamo broj n
	mov r4, r0

	@ Slucaj n < 2. Tada je rezultat 0.
	cmp r4, #2
	movlt r0, #0
	blt done

	@ Registar r5 ce nam biti brojac prostih brojeva. S obzirom da 
	@ je n >= 2, sigurno je bar jedan prost broj (2) manji ili 
	@ jednak od n. 
	mov r5, #1

	@ Registar r6 ce biti tekuci broj k za koji ispitujemo da li je 
	@ prost. Pocinjemo od 3, a zatim u svakoj iteraciji k uvecavamo
	@ za 2, zato sto parni brojevi veci od 2 nikada nisu prosti.
	mov r6, #3

next_number:
	@ Dokle god je k <= n
	cmp r6, r4
	bgt last_number

	@ Pozivamo pomocnu funkciju prime(k)
	mov r0, r6
	bl prime

	@ Ako je broj k prost, tada uvecavamo brojac.
	cmp r0, #0
	addne r5, r5, #1

	@ Uvecavamo k i prelazimo na sledecu iteraciju.
	add r6, r6, #2
	b next_number
last_number:

	@ Smestamo rezultat u r0.
	mov r0, r5

done:
	@ Vracamo vrednosti registara koje smo koristili.
	ldmfd sp!, {r4-r6}
	
	@ Epilog funkcije
	mov sp, fp
	ldmfd sp!, {fp, pc}


@ Funkcija:
@
@ int prime(int x);
@
@ odredjuje da li je broj x prost. Funkcija vreca 1 ako jeste, a 0 ako 
@ nije. Argument funkcije je:
@
@ -- r0 -- int x
@
prime:
	@ Prolog funkcije
	stmfd sp!, {fp, lr}
	mov fp, sp

	@ Cuvamo vrednosti registara koje cemo koristiti
        stmfd sp!, {r4-r6}

	@ Smestamo u r4 broj x.
 	mov r4, r0

	@ Registar r5 ce nam biti tekuci broj k za koji ispitujemo da
	@ li deli x	
	mov r5, #1

	@ Registar r6 ce nam biti brojac delilaca broja x.
	mov r6, #0

next:
	@ Dokle god je k <= x
	cmp r5, r4
	bgt last
	
	@ Odredjujemo x % k
	mov r0, r4
	mov r1, r5
	bl __modsi3

	@ Ako je x % k == 0, uvecavamo brojac.
	cmp r0, #0
	addeq r6, r6, #1

	@ Uvecavamo k i prelazimo na sledecu iteraciju.
	add r5, r5, #1
	b next
last:

	@ Ako je broj delilaca 2, tada je broj prost. U suprotnom nije.
	cmp r6, #2
	moveq r0, #1
	movne r0, #0

	@ Vracamo sa steka vrednosti registara koje smo koristili.
	ldmfd sp!, {r4-r6}

	@ Epilog funkcije.
	mov sp, fp
	ldmfd sp!, {fp, pc}


