.intel_syntax noprefix

.bss
.lcomm counters, 104  ## 26 brojaca za svako od slova (inicijalizovani nulom)
		
.text
.global most_frequent_letter

############################################################################# 
##
## Funkcija pronalazi i vraca najfrekventnije slovo u tekstu, kao i njegovu
## frekvenciju. Funkcija ne razlikuje mala i velika slova.
##
## void most_frequent_letter(char * text, char * letter, int * frequency); 
##
## char * text -- [ebp+8] -- tekst u kome se trazi najfrekventnije slovo.
## char * letter -- [ebp+12] -- adresa na koju treba upisati pronadjeno slovo.
## char * frequency -- [ebp+16] -- adresa na koju treba upisati frekvenciju.
#############################################################################
most_frequent_letter:	
	## Prolog funkcije
	enter 0,0
	push ebx
	push esi

	## U registar esi smestamo adresu stringa.
	mov esi, [ebp+8]

	## Registar eax postavljamo na nulu.
	xor eax, eax

	## Postavljamo smer kretanja kroz string (sa leva u desno).
	cld

next_char:
	## Ucitavamo sledeci karakter.
	lodsb

	## Uslov izlaska iz petlje: ako smo naisli na '\0' karakter.
	cmp al, 0
	je find

	## Ako je tekuci karakter manji od slova 'A' tada definitivno nije
	## slovo, pa prelazimo na sledeci karakter.
	cmp al, 'A'
	jl next_char

	## Ako je veci od 'Z', tada nije veliko slovo, pa prelazimo na proveru
	## da li je malo slovo.
	cmp al, 'Z'
	jg check_lower

	## Ako jeste veliko slovo, oduzimamo od njega 'A' i dobijamo vrednost
	## u intervalu 0-25 koja predstavlja indeks odgovarajuceg brojaca u
	## nizu counters.
	sub al, 'A'
	jmp count

check_lower:
	## Ako je manje od 'a', tada nije malo slovo, a kako od ranije znamo
	## da nije ni veliko, prelazimo na sledeci karakter.
	cmp al, 'a'
	jl next_char

	## Ako je vece od 'z' tada nije slovo, pa prelazimo na sledeci karakter.
	cmp al, 'z'
	jg next_char

	## Ako jeste malo slovo, oduzimamo od njega 'a' i dobijamo vrednost
	## u intervalu 0-25 koja predstavlja indeks odgovarajuceg brojaca u
	## nizu counters.
	sub al, 'a'
	
count:
	## Uvecavamo odgovarajuci brojac i prelazimo na sledeci karakter.
	inc dword ptr [4*eax + counters]
	jmp next_char

find:
	## U registar esi upisujemo adresu niza counters. Registar edx ce nam
	## cuvati najvecu vrednost u nizu brojaca, a registar bl ce cuvati
	## najfrekventnije slovo. Inicijalno, edx postavljamo na -1, zato sto
	## znamo da su svi elementi niza nenegativni, pa ce vec u prvoj
	## iteraciji edx biti azuriran. Registar ecx postavljamo na broj
	## iteracija, tj. na 26.
	lea esi, counters
	mov edx, -1
	mov ecx, 26

next_counter:
	## Ucitavamo sledeci element niza.
	lodsd

	## Ako je veci od do sada najveceg, azuriramo edx i bl.
	cmp eax, edx
	jg found_greater

	## U suprotnom prelazimo na sledeci element niza.
	jmp continue

found_greater:
	## Racunamo ASCII kod slova (26 - ecx + 'a'), i upisujemo ga u bl.
	mov bl, 26
	sub bl, cl
	add bl, 'a'

	## Upisujemo vrednost brojaca u edx.
	mov edx, eax

continue:
	## Sledeci brojac.
	loop next_counter

finish:
	## Upisujemo vrednosti brojaca i karaktera u za to predvidjene
	## lokacije.
	mov eax, [ebp+12]
	mov [eax], bl
	mov eax, [ebp+16]
	mov [eax], edx

done:
	## Epilog funkcije.
	pop esi
	pop ebx
	leave
	ret
	