.intel_syntax noprefix


.text
.global mirror

##############################################################################
##
## Funkcija mirror() vraca broj ciji se binarni zapis dobija obrtanjem
## binarnog zapisa broja x kao u ogledalu.  
##
## unsigned mirror(unsigned x);
##
## -- unsigned x -- [ebp+8] -- ceo broj ciji se binarni zapis obrce 
##
##############################################################################
mirror:
	## Prolog funkcije
	enter 0,0

	## U registar edx upisujemo broj x. U registar ecx upisujemo 32 (broj
	## iteracija u petlji). U registar eax upisujemo 0. U ovaj registar
	## cemo upisivati bitove rezultata. 
	mov edx, [ebp+8]
	mov ecx, 32
	xor eax, eax
	
	## U svakoj iteraciji petlje ce se naredni bit broja x (gledano sa
	## desna u levo) istiskivati u CF shiftovanjem u desno, a zatim ce se
	## ubacivati sa desne strane u rezultat rotacijom u levo kroz CF. Ovaj
	## postupak se ponavlja 32 puta, za svaki bit po jednom.
next_bit:
	shr edx,1
	rcl eax,1
	loop next_bit

	## Na kraju se u registru eax nalazi rezultat.
	
done:
	## Epilog funkcije
	leave
	ret
	