.intel_syntax noprefix

.text 
.global bubble_sort

############################################################################
## void bubble_sort(int * array, int n); 
##
## Funkcija sortira niz celih brojeva duzine n metodom 'bubble sort'.
## Funkcija je implementirana rekurzivno.
##
## -- [ebp+8] -- int * array -- adresa niza koji sortiramo
## -- [ebp+12] -- int n -- broj elemenata niza
##
############################################################################	
bubble_sort:
	enter 0,0
	push esi

	## Ucitavamo u esi adresu niza, a u ecx broj elemenata u nizu.
	mov esi, [ebp+8]
	mov ecx, [ebp+12]

	## Izlaz iz rekurzije: ako  niz  nema  vise od jednog elementa, tada
	## nemamo sta da sortiramo. Izlazimo iz rekurzije. 
	cmp ecx,1
	jle done

	## Potreban broj iteracija je za jedan manji od duzine niza, pa zato
	## umanjujemo ecx za jedan. 
	dec ecx

	## Odmah na stek postavljamo argumente rekurzivnog poziva, s obzirom
	## da su nam  vec poznati. ecx ima vrednost n-1 sto je upravo duzina
	## dela niza koji se predaje rekurzivnom pozivu.
	push ecx
	push esi

	## Postavljamo smer kretanja u nizu s leva u desno.
	cld

next_element:
	## Ucitavamo  tekuci element niza i poredimo ga sa sledecim. Kako se
	## instrukcijom lodsd esi registar  automatki pomera u desno, adresa
	## sledeceg elementa je upravo esi.Ukoliko je prethodni element veci 
	## od sledeceg, tada je potrebno zameniti ih. U suprotnom se prelazi
	## na sledeci element.
	lodsd
	cmp eax, [esi]
	jg swap
	jmp continue

	## Zamena tekuceg i sledeceg elementa. Tekuci element je  u registru
	## eax, a sledeci je na adresi esi. Adresa tekuceg je esi-4.
swap:
	xchg eax,[esi]
	mov [esi-4],eax
	
continue:	
	loop next_element

	## Rekurzivni poziv: bubble_sort(array, n - 1). Argumenti su  vec na
	## steku. Nakon poziva ih skidamo sa steka.
recursion:
	call bubble_sort
	add esp,8

	## Epilog funkcije.
done:	
	pop esi
	leave
	ret
	