.intel_syntax noprefix
        
.text
.global rational

############################################################################	
## Funkcija
##
## float rational(int m, float *p, int n, float *q, float x);
##
## izracunava datu racionalnu funkciju za datu vrednost. Argumenti funkcije
## su:
##
##  -- int m -- [ebp+8] - broj koeficijenata polinoma u brojiocu funkcije
##  -- float * p -- [ebp+12] - adresa niza koeficijenata polinoma u brojiocu
##                             funkcije
##  -- int n -- [ebp+16] - broj koeficijenata polinoma u imeniocu funkcije
##  -- float * q -- [ebp+20] - adresa niza koeficijenata polinoma u imeniocu
##                             funkcije
##  -- float x -- [ebp+24] - vrednost za koju se izracunava funkcija
##
## Funkcija vraca izracunatu vrednost. 
###########################################################################
rational:
        ## Prolog funkcije.
	enter   0, 0
        push    esi

        ## Ucitava se vrednost za koju se racuna funkcija.
        fld     dword ptr [ebp+24]      # Stek: x

        ## Racuna se vrednost polinoma u brojiocu funkcije.  Radi
	## efikasnijeg racunanja, izraz za polinom u brojiocu:
        ##   P(x)=p[0]+p[1]*x+...+p[m-1]*x^(m-1)
        ## se transformise u oblik:
        ##   P(x)=((...(p[m-1]*x+p[m-2])*x+...)*x+p[1])*x+p[0]
        ## Registar esi ce sadrzati adresu tekuceg koeficijenta polinoma
	## u brojiocu i inicijalizuje se na adresu koeficijenta p[m-1].
	## Registar ecx se koristi kao brojac u petlji.
        mov     ecx, [ebp+8]
        mov     esi, [ebp+12]
        mov     eax, ecx
        dec     eax
        shl     eax, 2
        add     esi, eax

        ## Na stek se stavlja koeficijent p[m-1] cime zapocinje
	## izracunavanje polinoma P(x).
        fld     dword ptr [esi]         # Stek: x, p[m-1]=Pp[0]
        sub     esi, 4
        dec     ecx
        jecxz calculate_Q
        
next_p:
        ## U petlji se izracunava vrednost P(x) prema gore datom
	## izrazu.
        fmul    st, st(1)               # Stek: x, Pp[i]*x
        fadd    dword ptr [esi]         # Stek: x, Pp[i]*x+p[m-1-i]=Pp[i+1]
        sub     esi, 4
        loop next_p
        
calculate_Q:
        ## Vrednost polinoma u imeniocu se izracunava na isti nacin
        ## kao vrednost polinoma u brojiocu; registri se takodje
	## koriste na isti nacin.
        mov     ecx, [ebp+16]
        mov     esi, [ebp+20]
        mov     eax, ecx
        dec     eax
        shl     eax, 2
        add     esi, eax

        ## Na stek se stavlja koeficijent p[m-1] cime zapocinje
	## izracunavanje polinoma P(x).
        fld     dword ptr [esi]         # Stek: x, P(x), q[n-1]=Qp[0]
        sub     esi, 4
        dec     ecx
        jecxz calculate_R
        
next_q:
        ## U petlji se izracunava vrednost P(x) prema gore datom
	## izrazu.
        fmul    st, st(2)               # Stek: x, P(x), Qp[i]*x
        fadd    dword ptr [esi]         # Stek: x, P(x), Qp[i]*x+q[n-1-i]=Qp[i+1]
        sub     esi, 4
        loop next_q
        
calculate_R:
        ## Izracunava se funkcija kao kolicnik gore izracunatih polinoma
        ## u brojiocu i imeniocu i uklanja se steka vrednost za koju
	## je racunata funkcija.
        fdivp                           # Stek: x, P(x)/Q(x)=R(x)
        fxch                            # Stek: R(x), x
        ffree   st                      # Stek: R(x), invalidna vrednost
        fincstp                         # Stek: R(x)
        
	## Epilog funkcije.
        pop     esi
	leave
        ret
