.text
.align 2


.global takeuchi

@ Funkcija:
@
@ int takeuchi(int x, int y, int z);
@
@ Izracunava Takeuchi-jevu funkciju definisanu na sledeci nacin:
@
@ f(x, y, z) = 1 + f(f(x-1,y,z),f(y-1,z,x),f(z-1,x,y)), za y < x,
@            = z,                                          inace
@  
@ Argumenti funkcije su:
@
@ int x -- r0
@ int y -- r1
@ int z -- r2
@
takeuchi:
	@ Prolog funkcije
	stmfd sp!, {fp, lr}
	mov fp, sp

	@ Cuvamo na steku registre koje cemo da koristimo.
	stmfd sp!, {r4-r9} 

	@ Kopiramo vrednosti argumenata
	mov r4, r0 
	mov r5, r1
	mov r6, r2

	@ Izlaz iz rekurzije (y >= x); u tom slucaju funkcija vraca z.
	cmp r5, r4
	movge r0, r6
	bge done

	@ U slucaju y < x, ulazimo u rekurzivne pozive.
	

	@ Pozivamo f(x-1,y,z) i rezultat smestamo u r7
	sub r0, r0, #1
	bl takeuchi
	mov r7, r0
	
	@ Pozivamo f(y-1,z,x) i rezultat smestamo u r8
	sub r0, r5, #1
	mov r1, r6
	mov r2, r4
	bl takeuchi
	mov r8, r0

	@ Pozivamo f(z-1,x,y) i rezultat smestamo u r9
	sub r0, r6, #1
	mov r1, r4
	mov r2, r5
	bl takeuchi
	mov r9, r0

	@ Pozivamo f(r7,r8,r9)
	mov r0, r7
	mov r1, r8
	mov r2, r9
	bl takeuchi
	
	@ Dodajemo 1 na prethodni rezultat.
	add r0, r0, #1

done:
	@ Skidamo sa steka vrednosti registara koje smo koristili.
	ldmfd sp!, {r4-r9}

	@ Epilog funkcije
	mov sp, fp
	ldmfd sp!, {fp, pc}

