.intel_syntax noprefix

.text
.global hyperbolic_sine

###########################################################################
##
## Funkcija izracunava vrednost funkcije sinh(x) u tacki x
## koristeci razvoj sum_{i>0}x^(2*i+1)/(2*i+1)!. Sumiraju se sabirci sve dok
## sabirak koji se dodaje sledeci ne postane po apsolutnoj vrednosti manji
## od eps.
##	
## double hyperbolic_sine(double x, double eps);
##
## -- double x   -- [ebp+8]  -- broj za koji racunamo vrednost
## -- double eps -- [ebp+16] -- zadata preciznost
##
##########################################################################

hyperbolic_sine:
	## Prolog funkcije
	enter 0,0

	## Inicijalizujemo stek.
	fld qword ptr [ebp+8]       ## stek: x
	fld qword ptr [ebp+16]      ## stek: x = S,eps
	fld st(1)		    ## stek: S,eps,x
	fmul st(0), st(0)	    ## stek: S,eps,x^2
	fld1			    ## stek: S,eps,x^2,2k + 1 = c (za k = 0)
	fld st(3)		    ## stek: S,eps,x^2,c,x = s
				    ## stek: S,eps,x^2,c,s

	## s -- tekuci sabirak (inicijalno x)
	## S -- trenutna vrednost sume (inicijalno x)
	## c -- tekuca vrednost 2k+1 (inicijalno 1)

next:
	## U svakoj iteraciji se racuna sledeci sabirak, polazeci od tekuceg
	## tako sto se najpre pomnozi sa x^2 a zatim podeli sa c+1 i c+2.
	fmul st(0), st(2)          ## stek: S,eps,x^2,c,s*x^2=s'
	fld1			   ## stek: S,eps,x^2,c,s',1
	faddp st(2), st(0)         ## stek: S,eps,x^2,c+1=c',s'
	fdiv st(0), st(1)          ## stek: S,eps,x^2,c',s'/c' = s''
	fld1 		           ## stek: S,eps,x^2,c',s'',1
	faddp st(2), st(0)	   ## stek: S,eps,x^2,c'+1=c'',s''
	fdiv st(0), st(1)          ## stek: S,eps,x^2,c'',s''/c''=s'''
				   ## stek: S,eps,x^2,c,s

	## Ako je sledeci sabirak manji od eps po apsolutnoj vrednosti,
	## tada se izlazi iz petlje, u suprotnom se dodaje na sumu i ide
	## se u sledecu iteraciju.
	fld st(0)                  ## stek: S,eps,x^2,c,s,s
	fabs                       ## stek: S,eps,x^2,c,s,|s|
	fcomip st(0), st(4)	   ## stek: S,eps,x^2,c,s

	## Ako je |s|<eps
	jb finish

	## Dodajemo sabirak na sumu.
	fadd st(4), st(0)          ## stek: S+s,eps,x^2,c,s
				   ## stek: S,eps,x^2,c,s
	## Sledeca iteracija.
	jmp next

finish:
	## Skidamo sa steka nepotrebne vrednosti.
	fcompp			    ## stek: S,eps,x^2
	fcompp			    ## stek: S
			
done:	
	## Epilog funkcije
	leave
	ret
	